/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.engine.step;

import com.google.common.collect.Lists;
import fr.enedis.chutney.action.spi.ActionExecutionResult;
import fr.enedis.chutney.action.spi.injectable.Target;
import fr.enedis.chutney.engine.domain.environment.TargetImpl;
import fr.enedis.chutney.engine.domain.execution.RxBus;
import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.StepDefinition;
import fr.enedis.chutney.engine.domain.execution.engine.StepExecutor;
import fr.enedis.chutney.engine.domain.execution.engine.evaluation.EvaluationException;
import fr.enedis.chutney.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContext;
import fr.enedis.chutney.engine.domain.execution.engine.step.StepContext;
import fr.enedis.chutney.engine.domain.execution.engine.step.StepState;
import fr.enedis.chutney.engine.domain.execution.event.BeginStepExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.EndStepExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.PauseStepExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import fr.enedis.chutney.engine.domain.execution.report.StepExecutionReport;
import fr.enedis.chutney.engine.domain.execution.strategies.StepStrategyDefinition;
import fr.enedis.chutney.tools.Try;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Step {
    private static final Logger LOGGER = LoggerFactory.getLogger(Step.class);
    private final StepDefinition definition;
    private final StepState state;
    private final List<Step> steps;
    private Target target;
    private final StepExecutor executor;
    private final StepDataEvaluator dataEvaluator;
    private StepContext stepContext;

    public Step(StepDataEvaluator dataEvaluator, StepDefinition definition, StepExecutor executor, List<Step> steps) {
        this.dataEvaluator = dataEvaluator;
        this.definition = definition;
        this.target = definition.getTarget().orElse(TargetImpl.NONE);
        this.executor = executor;
        this.steps = steps;
        this.state = new StepState(definition.name);
        this.stepContext = new StepContext();
    }

    public static Step nonExecutable(StepDefinition definition) {
        return new Step(null, definition, null, Collections.emptyList());
    }

    public Status execute(ScenarioExecution scenarioExecution, ScenarioContext scenarioContext) {
        return this.execute(scenarioExecution, scenarioContext, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status execute(ScenarioExecution scenarioExecution, ScenarioContext scenarioContext, Map<String, Object> localContext) {
        if (scenarioExecution.hasToPause()) {
            Instant startPauseInstant = Instant.now();
            this.pauseExecution(scenarioExecution);
            scenarioExecution.waitForRestart();
            this.state.resumeExecution();
            this.state.addInformation("Step pause from " + String.valueOf(startPauseInstant) + " to " + String.valueOf(Instant.now()));
        }
        if (scenarioExecution.hasToStop()) {
            this.stopExecution(scenarioExecution);
            return Status.STOPPED;
        }
        this.beginExecution(scenarioExecution);
        try {
            Map<String, Object> evaluationContext = this.buildEvaluationContext(scenarioContext, localContext);
            Map<String, Object> evaluatedInputs = this.definition.type.equals("final") ? this.definition.inputs() : Collections.unmodifiableMap(this.dataEvaluator.evaluateNamedDataWithContextVariables(this.definition.inputs(), evaluationContext));
            this.target = this.dataEvaluator.evaluateTarget(this.target, evaluationContext);
            this.resolveName(evaluationContext);
            Try.exec(() -> {
                this.stepContext = new StepContext(scenarioContext, localContext, evaluatedInputs);
                return this.stepContext;
            }).ifSuccess(stepContextExecuted -> {
                this.executor.execute(scenarioExecution, this.target, this);
                if (Status.SUCCESS.equals((Object)this.state.status())) {
                    this.executeStepValidations((StepContext)stepContextExecuted);
                }
                this.stepContext = stepContextExecuted.copy();
            }).ifFailed(this::failure);
        }
        catch (EvaluationException e) {
            this.failure(e);
        }
        catch (RuntimeException e) {
            this.failure(e);
            LOGGER.warn("Intercepted exception!", (Throwable)e);
        }
        finally {
            this.endExecution(scenarioExecution);
        }
        return this.state.status();
    }

    public void beginExecution(ScenarioExecution scenarioExecution) {
        this.state.beginExecution();
        RxBus.getInstance().post(new BeginStepExecutionEvent(scenarioExecution, this));
    }

    public void endExecution(ScenarioExecution scenarioExecution) {
        this.state.endExecution(this.isParentStep());
        RxBus.getInstance().post(new EndStepExecutionEvent(scenarioExecution, this));
    }

    public void stopExecution(ScenarioExecution scenarioExecution) {
        this.state.addInformation("Stop requested before executing this step");
        this.state.stopExecution();
        RxBus.getInstance().post(new EndStepExecutionEvent(scenarioExecution, this));
    }

    public void pauseExecution(ScenarioExecution scenarioExecution) {
        this.state.pauseExecution();
        RxBus.getInstance().post(new PauseStepExecutionEvent(scenarioExecution, this));
    }

    public String name() {
        return this.state.name();
    }

    public void resolveName(Map<String, Object> context) {
        this.state.setName(this.dataEvaluator.silentEvaluateString(this.state.name(), context));
    }

    public Status status() {
        if (this.isParentStep()) {
            Status worstSubStepsStatus = Status.worst(this.subStepsStatus());
            if (Status.PAUSED.equals((Object)worstSubStepsStatus)) {
                return Status.PAUSED;
            }
            if (Status.RUNNING.equals((Object)this.state.status())) {
                return Status.RUNNING;
            }
            return worstSubStepsStatus;
        }
        return this.state.status();
    }

    private List<Status> subStepsStatus() {
        if (!this.isParentStep() || Status.FAILURE.equals((Object)this.state.status())) {
            return Lists.newArrayList((Object[])new Status[]{this.state.status()});
        }
        return new ArrayList<Step>(this.steps).stream().filter(Objects::nonNull).map(Step::status).collect(Collectors.toList());
    }

    public void addInformation(String ... info) {
        this.state.addInformation(info);
    }

    public void addErrorMessage(String ... errors) {
        this.state.addErrors(errors);
    }

    public void failure(Throwable e) {
        this.failure(Optional.ofNullable(e.getMessage()).orElse(e.toString()));
    }

    public void failure(String ... message) {
        this.state.errorOccurred(message);
    }

    public void success(String ... message) {
        this.state.successOccurred(message);
    }

    public void resetExecution() {
        this.state.reset();
        this.steps.forEach(Step::resetExecution);
    }

    public void startWatch() {
        this.state.startWatch();
    }

    public void stopWatch() {
        this.state.stopWatch();
    }

    public Duration duration() {
        return this.state.duration();
    }

    public Instant startDate() {
        return this.state.startDate();
    }

    public List<String> informations() {
        return this.state.informations();
    }

    public List<String> errors() {
        return this.state.errors();
    }

    public Target target() {
        return this.target;
    }

    public StepDefinition definition() {
        return this.definition;
    }

    public Optional<StepStrategyDefinition> strategy() {
        return this.definition.getStrategy();
    }

    public String type() {
        return this.definition.type;
    }

    public List<Step> subSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public StepExecutor executor() {
        return this.executor;
    }

    public StepDataEvaluator dataEvaluator() {
        return this.dataEvaluator;
    }

    public Boolean isForStrategyApplied() {
        return this.state.isForStrategyApplied();
    }

    public void setIsForStrategyApplied(Boolean isForStrategyApplied) {
        this.state.setIsForStrategyApplied(isForStrategyApplied);
    }

    public boolean isParentStep() {
        return !this.steps.isEmpty();
    }

    public void updateContextFrom(StepExecutionReport remoteReport) {
        ActionExecutionResult.Status status = Status.SUCCESS.equals((Object)remoteReport.status) ? ActionExecutionResult.Status.Success : ActionExecutionResult.Status.Failure;
        this.updateContextWith(status, remoteReport.stepResults, Collections.emptyList(), Collections.emptyList());
    }

    public void updateContextFrom(ActionExecutionResult actionResult) {
        this.updateContextWith(actionResult.status, actionResult.outputs, Collections.emptyList(), Collections.emptyList());
    }

    private Map<String, Object> buildEvaluationContext(ScenarioContext scenarioContext, Map<String, Object> localContext) {
        HashMap<String, Object> evaluationContext = new HashMap<String, Object>();
        evaluationContext.putAll(scenarioContext);
        evaluationContext.putAll(localContext);
        evaluationContext.put("target", this.target);
        return evaluationContext;
    }

    private void updateContextWith(ActionExecutionResult.Status status, Map<String, Object> actionOutputs, List<String> information, List<String> errors) {
        if (status == ActionExecutionResult.Status.Success) {
            Try.exec(() -> {
                this.updateContextWithActionOutputs(actionOutputs);
                this.updateContextWithDefinitionOutputs();
                this.success(new String[0]);
                return null;
            }).ifFailed(e -> this.failure("Cannot evaluate outputs. - Exception: " + String.valueOf(e.getClass()) + " with message: \"" + e.getMessage() + "\""));
        } else {
            this.failure(Lists.newArrayList(errors).toArray(new String[errors.size()]));
        }
        this.addInformation(Lists.newArrayList(information).toArray(new String[information.size()]));
    }

    private void updateContextWithActionOutputs(Map<String, Object> actionOutputs) {
        this.stepContext.addStepOutputs(actionOutputs);
        this.stepContext.addScenarioContext(actionOutputs);
    }

    private void updateContextWithDefinitionOutputs() {
        Map<String, Object> evaluatedOutputs = this.dataEvaluator.evaluateNamedDataWithContextVariables(this.definition.outputs, this.stepContext.evaluationContext());
        this.stepContext.addStepOutputs(evaluatedOutputs);
        this.stepContext.addScenarioContext(evaluatedOutputs);
    }

    private void executeStepValidations(StepContext stepContext) {
        Try.exec(() -> {
            Map<String, Object> evaluatedValidations = this.dataEvaluator.evaluateNamedDataWithContextVariables(this.definition.validations, stepContext.evaluationContext());
            evaluatedValidations.forEach((k, v) -> {
                if (!((Boolean)v).booleanValue()) {
                    this.failure("Validation [" + k + " : " + this.definition.validations.get(k).toString() + "] : KO");
                } else {
                    this.state.addInformation("Validation [" + k + " : " + this.definition.validations.get(k).toString() + "] : OK");
                }
            });
            return null;
        }).ifFailed(e -> this.failure("Step validation failed. - Exception: " + String.valueOf(e.getClass()) + " with message: \"" + e.getMessage() + "\""));
    }

    public void addStepExecution(Step step) {
        this.steps.add(step);
    }

    public Map<String, Object> getEvaluatedInputs() {
        return Collections.unmodifiableMap(this.stepContext.getEvaluatedInputs());
    }

    public Map<String, Object> getScenarioContext() {
        return this.stepContext.getScenarioContext().unmodifiable();
    }

    public Map<String, Object> getStepOutputs() {
        return Collections.unmodifiableMap(this.stepContext.getStepOutputs());
    }

    public Map<String, Object> getStepContextInputSnapshot() {
        return this.stepContext.getStepContextSnapshot().getInputsSnapshot();
    }

    public Map<String, Object> getStepContextOutputSnapshot() {
        return this.stepContext.getStepContextSnapshot().getOutputsSnapshot();
    }

    public void removeStepExecution() {
        this.steps.clear();
    }
}

