/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.engine.step;

import com.google.common.collect.Maps;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContext;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContextImpl;
import fr.enedis.chutney.engine.domain.execution.engine.step.StepContextSnapshot;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

class StepContext {
    private final ScenarioContext scenarioContext;
    private final Map<String, Object> localContext;
    private final Map<String, Object> evaluatedInputs;
    private final Map<String, Object> stepOutputs;
    private StepContextSnapshot stepContextSnapshot;

    StepContext() {
        this(new ScenarioContextImpl(), new LinkedHashMap<String, Object>(), new LinkedHashMap<String, Object>());
    }

    StepContext(ScenarioContext scenarioContext, Map<String, Object> localContext, Map<String, Object> evaluatedInputs) {
        this(scenarioContext, localContext, evaluatedInputs, new LinkedHashMap<String, Object>());
    }

    private StepContext(ScenarioContext scenarioContext, Map<String, Object> localContext, Map<String, Object> evaluatedInputs, Map<String, Object> stepOutputs) {
        this.scenarioContext = scenarioContext;
        this.localContext = localContext;
        this.evaluatedInputs = evaluatedInputs;
        this.stepOutputs = stepOutputs;
        this.stepContextSnapshot = new StepContextSnapshot();
    }

    private StepContext copySnapshotsInputOutput() {
        this.stepContextSnapshot = new StepContextSnapshot(this.evaluatedInputs, this.stepOutputs);
        return this;
    }

    public StepContextSnapshot getStepContextSnapshot() {
        return this.stepContextSnapshot;
    }

    Map<String, Object> evaluationContext() {
        LinkedHashMap allResults = Maps.newLinkedHashMap((Map)this.scenarioContext);
        allResults.putAll(this.localContext);
        allResults.putAll(this.stepOutputs);
        return allResults;
    }

    ScenarioContext getScenarioContext() {
        return this.scenarioContext;
    }

    Map<String, Object> getEvaluatedInputs() {
        return Optional.ofNullable(this.evaluatedInputs).orElse(Collections.emptyMap());
    }

    void addStepOutputs(Map<String, Object> stepOutputs) {
        if (stepOutputs != null) {
            this.stepOutputs.putAll(stepOutputs);
        }
    }

    void addScenarioContext(Map<String, Object> context) {
        if (context != null) {
            this.scenarioContext.putAll(context);
        }
    }

    Map<String, Object> getStepOutputs() {
        return Optional.ofNullable(this.stepOutputs).orElse(Collections.emptyMap());
    }

    StepContext copy() {
        return new StepContext(this.scenarioContext.unmodifiable(), Collections.unmodifiableMap(this.localContext), Collections.unmodifiableMap(this.evaluatedInputs), Collections.unmodifiableMap(this.stepOutputs)).copySnapshotsInputOutput();
    }
}

