/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.engine.step;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.enedis.chutney.engine.domain.execution.engine.step.jackson.ReportObjectMapperConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class StepContextSnapshot {
    private final Map<String, Object> inputsSnapshot;
    private final Map<String, Object> outputsSnapshot;

    public StepContextSnapshot() {
        this.inputsSnapshot = Collections.emptyMap();
        this.outputsSnapshot = Collections.emptyMap();
    }

    public StepContextSnapshot(Map<String, Object> inputsSnapshot, Map<String, Object> outputsSnapshot) {
        this.inputsSnapshot = this.mapStringObjectToString(inputsSnapshot);
        this.outputsSnapshot = this.mapStringObjectToString(outputsSnapshot);
    }

    public Map<String, Object> getInputsSnapshot() {
        return Collections.unmodifiableMap(this.inputsSnapshot);
    }

    public Map<String, Object> getOutputsSnapshot() {
        return Collections.unmodifiableMap(this.outputsSnapshot);
    }

    private Map<String, Object> mapStringObjectToString(Map<String, Object> originalMap) {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        originalMap.forEach((key, value) -> {
            try {
                String stringObject = ReportObjectMapperConfiguration.reportObjectMapper().writeValueAsString(value);
                JsonNode jsonObject = ReportObjectMapperConfiguration.reportObjectMapper().readTree(stringObject);
                stringMap.put((String)key, jsonObject);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return stringMap;
    }
}

