/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.evaluation;

import fr.enedis.chutney.action.spi.SpelFunction;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpelFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpelFunctions.class);
    private final Map<String, NamedFunctionLink> methodByName = new HashMap<String, NamedFunctionLink>();

    void add(SpelFunction spelFunction, Method method) {
        String spelFunctionName = Optional.of(spelFunction.value()).filter(s -> !s.isEmpty()).orElse(method.getName());
        NamedFunctionLink previousDeclaration = this.methodByName.put(spelFunctionName, new NamedFunctionLink(this, spelFunctionName, method));
        if (previousDeclaration != null) {
            LOGGER.error("Loading function conflicting: {} ({}) with previous declaration {} ({})", new Object[]{spelFunctionName, method.getDeclaringClass().getSimpleName(), previousDeclaration.getName(), previousDeclaration.getMethod().getDeclaringClass().getSimpleName()});
        } else {
            LOGGER.debug("Loading function: {} ({})", (Object)spelFunctionName, (Object)method.getDeclaringClass().getSimpleName());
        }
    }

    public Stream<NamedFunctionLink> stream() {
        return this.methodByName.values().stream();
    }

    public class NamedFunctionLink {
        private final String name;
        private final Method method;

        public NamedFunctionLink(SpelFunctions this$0, String name, Method method) {
            this.name = name;
            this.method = method;
        }

        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

