/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StepExecutionReport
implements Status.HavingStatus {
    public final Long executionId;
    public final String name;
    public final String environment;
    public final Long duration;
    public final Instant startDate;
    public final Status status;
    public final List<String> information;
    public final List<String> errors;
    public final List<StepExecutionReport> steps;
    public final String type;
    public final String targetName;
    public final String targetUrl;
    public final String strategy;
    public final Map<String, Object> evaluatedInputs;
    public final Map<String, Object> evaluatedInputsSnapshot;
    @JsonIgnore
    public Map<String, Object> stepResults;
    @JsonIgnore
    public Map<String, Object> stepResultsSnapshot;
    @JsonIgnore
    public Map<String, Object> scenarioContext;

    @JsonCreator
    public StepExecutionReport(Long executionId, String name, String environment, Long duration, Instant startDate, Status status, List<String> information, List<String> errors, List<StepExecutionReport> steps, String type, String targetName, String targetUrl, String strategy) {
        this(executionId, name, environment, duration, startDate, status, information, errors, steps, type, targetName, targetUrl, strategy, null, null, null, null, null);
    }

    public StepExecutionReport(Long executionId, String name, String environment, Long duration, Instant startDate, Status status, List<String> information, List<String> errors, List<StepExecutionReport> steps, String type, String targetName, String targetUrl, String strategy, Map<String, Object> evaluatedInputs, Map<String, Object> stepResults, Map<String, Object> scenarioContext, Map<String, Object> evaluatedInputsSnapshot, Map<String, Object> stepResultsSnapshot) {
        this.executionId = executionId;
        this.name = name;
        this.environment = environment;
        this.duration = duration;
        this.startDate = startDate;
        this.status = status;
        this.information = evaluatedInputs != null ? information : Collections.emptyList();
        this.errors = evaluatedInputs != null ? errors : Collections.emptyList();
        this.steps = steps;
        this.type = type;
        this.targetName = targetName;
        this.targetUrl = targetUrl;
        this.strategy = strategy;
        this.evaluatedInputs = Optional.ofNullable(evaluatedInputs).orElse(Collections.emptyMap());
        this.evaluatedInputsSnapshot = Optional.ofNullable(evaluatedInputsSnapshot).orElse(Collections.emptyMap());
        this.stepResults = Optional.ofNullable(stepResults).orElse(Collections.emptyMap());
        this.stepResultsSnapshot = Optional.ofNullable(stepResultsSnapshot).orElse(Collections.emptyMap());
        this.scenarioContext = Optional.ofNullable(scenarioContext).orElse(Collections.emptyMap());
    }

    @Override
    public Status getStatus() {
        return this.status;
    }
}

