/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.strategies;

import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.engine.evaluation.EvaluationException;
import fr.enedis.chutney.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContext;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import fr.enedis.chutney.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategies;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepStrategyDefinition;
import java.util.HashMap;
import java.util.Map;

public class IfStrategy
implements StepExecutionStrategy {
    private static final String TYPE = "if";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        StepStrategyDefinition strategyDefinition = step.strategy().orElseThrow(() -> new IllegalArgumentException("Strategy definition cannot be empty"));
        Object conditionObject = strategyDefinition.strategyProperties.getProperty("condition", Object.class);
        if (conditionObject == null) {
            throw new IllegalArgumentException("Property [condition] mandatory for if strategy");
        }
        Boolean condition = IfStrategy.getCondition(scenarioContext, conditionObject, step.dataEvaluator());
        String conditionStatus = condition != false ? "step executed" : "step skipped";
        step.addInformation("Execution condition [" + String.valueOf(conditionObject) + "] = " + conditionStatus);
        if (condition.booleanValue()) {
            return DefaultStepExecutionStrategy.instance.execute(scenarioExecution, step, scenarioContext, localContext, strategies);
        }
        HashMap<String, Object> context = new HashMap<String, Object>(scenarioContext);
        context.putAll(localContext);
        step.resolveName(context);
        step.success(new String[0]);
        this.skipAllSubSteps(step);
        return Status.SUCCESS;
    }

    private void skipAllSubSteps(Step step) {
        if (step.isParentStep()) {
            step.subSteps().forEach(subStep -> {
                subStep.addInformation("Step skipped");
                subStep.success(new String[0]);
                this.skipAllSubSteps((Step)subStep);
            });
        }
    }

    private static Boolean getCondition(ScenarioContext scenarioContext, Object conditionObject, StepDataEvaluator evaluator) {
        if (conditionObject instanceof Boolean) {
            Boolean booleanCondition = (Boolean)conditionObject;
            return booleanCondition;
        }
        if (conditionObject instanceof String) {
            String stringCondition = (String)conditionObject;
            try {
                return (Boolean)evaluator.evaluate(stringCondition, scenarioContext);
            }
            catch (EvaluationException | ClassCastException e) {
                throw new RuntimeException("Cannot evaluate execution condition: [" + String.valueOf(conditionObject) + "]. Error message: " + e.getMessage());
            }
        }
        throw new RuntimeException("Cannot evaluate execution condition: [" + String.valueOf(conditionObject) + "]. should be a boolean or a Spring Expression Language which return a boolean");
    }
}

