/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.strategies;

import fr.enedis.chutney.action.spi.time.Duration;
import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContext;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContextImpl;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import fr.enedis.chutney.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategies;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepStrategyDefinition;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RetryWithTimeOutStrategy
implements StepExecutionStrategy {
    private static final String TYPE = "retry-with-timeout";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) throws IllegalStateException {
        Status st;
        if (step.strategy().isEmpty()) {
            throw new IllegalArgumentException("Should not have strategy definition empty for retry strategy");
        }
        StepStrategyDefinition strategyDefinition = step.strategy().get();
        String timeOut = strategyDefinition.strategyProperties.getProperty("timeOut", String.class);
        String retryDelay = strategyDefinition.strategyProperties.getProperty("retryDelay", String.class);
        if (timeOut == null) {
            throw new IllegalStateException("Undefined parameter 'timeOut'");
        }
        if (retryDelay == null) {
            throw new IllegalStateException("Undefined parameter 'retryDelay'");
        }
        ScenarioContextImpl mergedContext = new ScenarioContextImpl();
        mergedContext.putAll(scenarioContext);
        mergedContext.putAll(localContext);
        String evaluatedRetryDelay = step.dataEvaluator().evaluateString(retryDelay, mergedContext);
        String evaluatedTimeOut = step.dataEvaluator().evaluateString(timeOut, mergedContext);
        long retryDelayMs = this.toMilliSeconds(evaluatedRetryDelay);
        long timeLeft = this.toMilliSeconds(evaluatedTimeOut);
        int tries = 1;
        ArrayList<String> lastErrors = new ArrayList<String>();
        do {
            long tryStartTime = System.currentTimeMillis();
            step.addInformation("Retry strategy definition : [timeOut " + evaluatedTimeOut + "] [delay " + evaluatedRetryDelay + "]");
            step.addInformation("Try number : " + tries++);
            st = this.executeAll(scenarioExecution, step, scenarioContext, localContext, strategies);
            if (st == Status.FAILURE) {
                try {
                    step.startWatch();
                    TimeUnit.MILLISECONDS.sleep(retryDelayMs);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Sleeping between executions have been interrupted", e);
                }
                finally {
                    step.stopWatch();
                }
            } else {
                if (lastErrors.isEmpty()) break;
                step.addErrorMessage("Error(s) on last step execution:");
                lastErrors.forEach(xva$0 -> step.addErrorMessage((String)xva$0));
                break;
            }
            if ((timeLeft -= System.currentTimeMillis() - tryStartTime) <= 0L) continue;
            lastErrors.clear();
            lastErrors.addAll(step.errors());
            step.resetExecution();
        } while (timeLeft > 0L);
        return st;
    }

    private long toMilliSeconds(String duration) {
        double durationInMS = Duration.parse((String)duration).toMilliseconds();
        return Math.round(durationInMS);
    }

    private Status executeAll(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        Status st = DefaultStepExecutionStrategy.instance.execute(scenarioExecution, step, scenarioContext, localContext, strategies);
        if (st == Status.FAILURE) {
            if (scenarioExecution.hasToStop()) {
                step.stopExecution(scenarioExecution);
                return Status.STOPPED;
            }
            return st;
        }
        return Status.SUCCESS;
    }
}

