/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.infrastructure.delegation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import fr.enedis.chutney.engine.api.execution.StepExecutionReportDto;
import fr.enedis.chutney.engine.domain.delegation.CannotDelegateException;
import fr.enedis.chutney.engine.domain.delegation.ConnectionChecker;
import fr.enedis.chutney.engine.domain.delegation.DelegationClient;
import fr.enedis.chutney.engine.domain.delegation.NamedHostAndPort;
import fr.enedis.chutney.engine.domain.execution.engine.Dataset;
import fr.enedis.chutney.engine.domain.execution.engine.Environment;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.report.StepExecutionReport;
import fr.enedis.chutney.engine.infrastructure.delegation.ExecutionRequestMapper;
import fr.enedis.chutney.engine.infrastructure.delegation.StepExecutionReportMapper;
import fr.enedis.chutney.engine.infrastructure.delegation.TcpConnectionChecker;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClient
implements DelegationClient {
    private final RestTemplate restTemplate = new RestTemplate();
    private final ConnectionChecker connectionChecker = new TcpConnectionChecker();

    public HttpClient() {
        this(null, null);
    }

    public HttpClient(String username, String password) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.findAndRegisterModules();
        this.restTemplate.setMessageConverters((List)Lists.newArrayList((Object[])new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter(objectMapper)}));
        this.addBasicAuth(username, password);
    }

    @Override
    public StepExecutionReport handDown(Step step, NamedHostAndPort delegate) throws CannotDelegateException {
        if (this.connectionChecker.canConnectTo(delegate)) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            Dataset dataset = new Dataset(Collections.emptyMap(), Collections.emptyList());
            Environment environment = new Environment((String)step.getScenarioContext().get("environment"));
            HttpEntity request = new HttpEntity((Object)ExecutionRequestMapper.from(step.definition(), dataset, environment), (MultiValueMap)headers);
            StepExecutionReportDto reportDto = (StepExecutionReportDto)this.restTemplate.postForObject("https://" + delegate.host() + ":" + delegate.port() + "/api/scenario/execution/v1", (Object)request, StepExecutionReportDto.class, new Object[0]);
            return StepExecutionReportMapper.fromDto(reportDto);
        }
        throw new CannotDelegateException(delegate);
    }

    private void addBasicAuth(String user, String password) {
        if (Optional.ofNullable(user).isPresent()) {
            this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password));
        }
    }
}

