/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.api.execution;

import fr.enedis.chutney.engine.api.execution.ExecutionRequestDto;
import fr.enedis.chutney.engine.api.execution.StepExecutionReportDto;
import fr.enedis.chutney.engine.api.execution.TestEngine;
import io.reactivex.rxjava3.core.Observable;
import jakarta.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HttpTestEngine
implements TestEngine {
    public static final String EXECUTION_URL = "/api/scenario/execution/v1";
    private final TestEngine testEngine;

    public HttpTestEngine(TestEngine embeddedTestEngine) {
        this.testEngine = embeddedTestEngine;
    }

    @Override
    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/scenario/execution/v1"}, consumes={"application/json"}, produces={"application/json"})
    public StepExecutionReportDto execute(@Valid @RequestBody ExecutionRequestDto request) {
        return this.testEngine.execute(request);
    }

    @Override
    public Long executeAsync(ExecutionRequestDto request) {
        throw new IllegalArgumentException();
    }

    @Override
    public Observable<StepExecutionReportDto> receiveNotification(Long executionId) {
        throw new IllegalArgumentException();
    }

    @Override
    public void pauseExecution(Long executionId) {
        throw new IllegalArgumentException();
    }

    @Override
    public void resumeExecution(Long executionId) {
        throw new IllegalArgumentException();
    }

    @Override
    public void stopExecution(Long executionId) {
        throw new IllegalArgumentException();
    }

    @Override
    public void close() throws Exception {
        this.testEngine.close();
    }
}

