/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.api.execution;

import fr.enedis.chutney.engine.api.execution.StatusDto;
import fr.enedis.chutney.engine.api.execution.StepExecutionReportDto;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import fr.enedis.chutney.engine.domain.execution.report.StepExecutionReport;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class StepExecutionReportMapper {
    private StepExecutionReportMapper() {
    }

    static StepExecutionReportDto toDto(StepExecutionReport report) {
        return new StepExecutionReportDto(report.name, report.environment, report.startDate, report.duration, StatusMapper.toDto(report.status), report.information, report.errors, report.steps.stream().map(StepExecutionReportMapper::toDto).collect(Collectors.toList()), StepContextMapper.toDto(report.scenarioContext, report.evaluatedInputsSnapshot, report.stepResultsSnapshot), report.type, report.targetName, report.targetUrl, report.strategy);
    }

    static class StatusMapper {
        StatusMapper() {
        }

        static StatusDto toDto(Status status) {
            return StatusDto.valueOf(status.name());
        }
    }

    static class StepContextMapper {
        StepContextMapper() {
        }

        static StepExecutionReportDto.StepContextDto toDto(Map<String, Object> scenarioContext, Map<String, Object> evaluatedInputSnapshot, Map<String, Object> stepResultsSnapshot) {
            return new StepExecutionReportDto.StepContextDto(Optional.ofNullable(scenarioContext).orElse(Collections.EMPTY_MAP), Optional.ofNullable(evaluatedInputSnapshot).orElse(Collections.EMPTY_MAP), Optional.ofNullable(stepResultsSnapshot).orElse(Collections.EMPTY_MAP));
        }
    }
}

