/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.delegation;

import fr.enedis.chutney.action.spi.injectable.Target;
import fr.enedis.chutney.engine.domain.delegation.CannotDelegateException;
import fr.enedis.chutney.engine.domain.delegation.DelegationClient;
import fr.enedis.chutney.engine.domain.delegation.NamedHostAndPort;
import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.engine.StepExecutor;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.report.StepExecutionReport;
import org.springframework.util.Assert;

public class RemoteStepExecutor
implements StepExecutor {
    private final DelegationClient delegationClient;
    private final NamedHostAndPort agentInfo;

    public RemoteStepExecutor(DelegationClient delegationClient, NamedHostAndPort agentInfo) {
        this.delegationClient = delegationClient;
        this.agentInfo = agentInfo;
    }

    @Override
    public void execute(ScenarioExecution scenarioExecution, Target target, Step step) {
        try {
            StepExecutionReport remoteReport = this.delegationClient.handDown(step, this.agentInfo);
            this.guardFromIllegalReport(remoteReport);
            step.updateContextFrom(remoteReport);
        }
        catch (CannotDelegateException e) {
            step.failure(e);
        }
    }

    private void guardFromIllegalReport(StepExecutionReport remoteReport) {
        Assert.notNull(remoteReport.evaluatedInputs, (String)"EvaluatedInputs are null after delegation. 0_o !");
        Assert.notNull(remoteReport.scenarioContext, (String)"ScenarioContext is null after delegation. 0_o !");
        Assert.notNull(remoteReport.stepResults, (String)"StepResults are null after delegation. 0_o !");
        Assert.notNull((Object)((Object)remoteReport.status), (String)"Status is null after delegation. 0_o !");
        Assert.notNull(remoteReport.information, (String)"Information are null after delegation. 0_o !");
        Assert.notNull(remoteReport.errors, (String)"Errors are null after delegation. 0_o !");
    }
}

