/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution;

import fr.enedis.chutney.engine.domain.execution.event.Event;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(RxBus.class);
    private static final RxBus INSTANCE = new RxBus();
    private final Subject<Object> bus = PublishSubject.create().toSerialized();

    public static RxBus getInstance() {
        return INSTANCE;
    }

    public void post(Object event) {
        try {
            this.bus.onNext(event);
        }
        catch (Exception e) {
            LOGGER.error("Error while posting event: {}", (Object)event.getClass().getSimpleName(), (Object)e);
        }
    }

    public <T> Disposable register(Class<T> eventClass, Consumer<T> onNext) {
        return this.bus.filter(eventClass::isInstance).map(eventClass::cast).subscribe(onNext, throwable -> LOGGER.error("Error while processing event: {}", (Object)eventClass.getSimpleName(), throwable));
    }

    public <T extends Event> Disposable registerOnExecutionId(Class<T> eventClass, long executionId, Consumer<? super Event> onNext) {
        return this.bus.filter(event -> event.getClass().equals(eventClass)).map(obj -> (Event)obj).filter(e -> e.executionId() == executionId).subscribe(onNext, throwable -> LOGGER.error("Error while processing event for executionId {}: {}", new Object[]{executionId, throwable.getMessage(), throwable}));
    }

    public Observable<Object> toObservable() {
        return this.bus;
    }
}

