/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.engine;

import fr.enedis.chutney.action.domain.ActionTemplate;
import fr.enedis.chutney.action.domain.ActionTemplateRegistry;
import fr.enedis.chutney.action.domain.parameter.ParameterResolver;
import fr.enedis.chutney.action.spi.Action;
import fr.enedis.chutney.action.spi.ActionExecutionResult;
import fr.enedis.chutney.action.spi.injectable.ActionsConfiguration;
import fr.enedis.chutney.action.spi.injectable.FinallyActionRegistry;
import fr.enedis.chutney.action.spi.injectable.StepDefinitionSpi;
import fr.enedis.chutney.action.spi.injectable.Target;
import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.StepDefinition;
import fr.enedis.chutney.engine.domain.execution.engine.StepExecutor;
import fr.enedis.chutney.engine.domain.execution.engine.parameterResolver.ContextParameterResolver;
import fr.enedis.chutney.engine.domain.execution.engine.parameterResolver.DelegateLogger;
import fr.enedis.chutney.engine.domain.execution.engine.parameterResolver.InputParameterResolver;
import fr.enedis.chutney.engine.domain.execution.engine.parameterResolver.TypedValueParameterResolver;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStepExecutor
implements StepExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStepExecutor.class);
    private final ActionTemplateRegistry actionTemplateRegistry;

    public DefaultStepExecutor(ActionTemplateRegistry actionTemplateRegistry) {
        this.actionTemplateRegistry = actionTemplateRegistry;
    }

    @Override
    public void execute(ScenarioExecution scenarioExecution, Target targetServer, Step step) {
        block7: {
            String type = step.type();
            Optional<ActionTemplate> matchedAction = this.actionTemplateRegistry.getByIdentifier(type);
            if (matchedAction.isPresent()) {
                List<ParameterResolver> parameterResolvers = this.gatherResolvers(scenarioExecution, targetServer, step);
                try {
                    Action action = matchedAction.get().create(parameterResolvers);
                    List errors = action.validateInputs();
                    if (errors.isEmpty()) {
                        ActionExecutionResult executionResult = action.execute();
                        step.updateContextFrom(executionResult);
                        break block7;
                    }
                    step.failure(errors.toArray(new String[0]));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot execute step: ", (Throwable)e);
                    step.failure("Action [" + type + "] failed: " + Optional.ofNullable(e.getMessage()).orElse(e.toString()));
                }
            } else if (type.isEmpty()) {
                step.success(new String[0]);
            } else {
                step.failure("Action [" + type + "] not found");
            }
        }
    }

    private List<ParameterResolver> gatherResolvers(ScenarioExecution scenarioExecution, Target target, Step step) {
        ArrayList<ParameterResolver> parameterResolvers = new ArrayList<ParameterResolver>();
        parameterResolvers.add(new InputParameterResolver(step.getEvaluatedInputs()));
        parameterResolvers.add(new TypedValueParameterResolver<Target>(Target.class, target));
        parameterResolvers.add(new TypedValueParameterResolver<DelegateLogger>(fr.enedis.chutney.action.spi.injectable.Logger.class, new DelegateLogger(xva$0 -> step.addInformation((String)xva$0), xva$0 -> step.failure((String)xva$0))));
        parameterResolvers.add(new TypedValueParameterResolver<StepDefinition>(StepDefinitionSpi.class, step.definition()));
        parameterResolvers.add(new TypedValueParameterResolver<FinallyActionRegistry>(FinallyActionRegistry.class, scenarioExecution::registerFinallyAction));
        parameterResolvers.add(new TypedValueParameterResolver<ActionsConfiguration>(ActionsConfiguration.class, scenarioExecution.getActionsConfiguration()));
        parameterResolvers.add(new ContextParameterResolver(step.getScenarioContext()));
        return parameterResolvers;
    }
}

