/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.strategies;

import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.StepDefinition;
import fr.enedis.chutney.engine.domain.execution.StepDefinitionBuilder;
import fr.enedis.chutney.engine.domain.execution.engine.StepExecutor;
import fr.enedis.chutney.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContext;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import fr.enedis.chutney.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategies;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepStrategyDefinition;
import fr.enedis.chutney.engine.domain.execution.strategies.StrategyProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class ForEachStrategy
implements StepExecutionStrategy {
    @Override
    public String getType() {
        return "for";
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        StepStrategyDefinition strategyDefinition = step.strategy().orElseThrow(() -> new IllegalArgumentException("Strategy definition cannot be empty"));
        List<Map<String, Object>> dataset = ForEachStrategy.getDataset(step, scenarioContext, strategyDefinition, step.dataEvaluator());
        if (this.executeRetryWithDataset(scenarioExecution, step, scenarioContext, localContext, strategies, dataset)) {
            return step.status();
        }
        String indexName = this.computeIndexName(strategyDefinition);
        step.beginExecution(scenarioExecution);
        this.replaceIndexInStepName(step, scenarioContext, localContext);
        if (step.isParentStep()) {
            this.executeParentStep(scenarioExecution, step, scenarioContext, localContext, strategies, dataset, indexName);
        } else {
            this.executeSubSteps(scenarioExecution, step, scenarioContext, localContext, dataset, indexName);
        }
        step.endExecution(scenarioExecution);
        return step.status();
    }

    private String computeIndexName(StepStrategyDefinition strategyDefinition) {
        return Optional.ofNullable(strategyDefinition.strategyProperties.get("index")).orElse("i");
    }

    private void replaceIndexInStepName(Step step, ScenarioContext scenarioContext, Map<String, Object> localContext) {
        HashMap<String, Object> context = new HashMap<String, Object>(scenarioContext);
        context.putAll(localContext);
        step.resolveName(context);
    }

    private void executeParentStep(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies, List<Map<String, Object>> dataset, String indexName) {
        AtomicInteger index = new AtomicInteger(0);
        List<Step> subSteps = List.copyOf(step.subSteps());
        step.removeStepExecution();
        List<Pair> iterations = dataset.stream().map(iterationContext -> this.buildParentIteration(indexName, index.getAndIncrement(), step, subSteps, (Map<String, Object>)iterationContext)).peek(p -> step.addStepExecution((Step)p.getLeft())).toList();
        iterations.forEach(it -> {
            HashMap<String, Object> mergedContext = new HashMap<String, Object>(localContext);
            mergedContext.putAll((Map)it.getRight());
            DefaultStepExecutionStrategy.instance.execute(scenarioExecution, (Step)it.getLeft(), scenarioContext, mergedContext, strategies);
        });
    }

    private void executeSubSteps(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, List<Map<String, Object>> dataset, String indexName) {
        AtomicInteger index = new AtomicInteger(0);
        List<Pair> iterations = dataset.stream().map(iterationContext -> this.buildIteration(indexName, index.getAndIncrement(), step, (Map<String, Object>)iterationContext)).peek(e -> step.addStepExecution((Step)e.getKey())).toList();
        iterations.forEach(it -> {
            HashMap<String, Object> mergedContext = new HashMap<String, Object>(localContext);
            mergedContext.putAll((Map)it.getRight());
            ((Step)it.getLeft()).execute(scenarioExecution, scenarioContext, mergedContext);
        });
    }

    private boolean executeRetryWithDataset(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies, List<Map<String, Object>> dataset) {
        if (step.isForStrategyApplied().booleanValue()) {
            step.beginExecution(scenarioExecution);
            IntStream.range(0, step.subSteps().size()).forEach(i -> {
                HashMap<String, Object> mergedContext = new HashMap<String, Object>(localContext);
                mergedContext.putAll((Map)dataset.get(i));
                Step stepToExecute = step.subSteps().get(i);
                DefaultStepExecutionStrategy.instance.execute(scenarioExecution, stepToExecute, scenarioContext, mergedContext, strategies);
            });
            step.endExecution(scenarioExecution);
            return true;
        }
        step.setIsForStrategyApplied(true);
        return false;
    }

    private static List<Map<String, Object>> getDataset(Step step, ScenarioContext scenarioContext, StepStrategyDefinition strategyDefinition, StepDataEvaluator evaluator) {
        List dataset = (List)step.dataEvaluator().evaluate(strategyDefinition.strategyProperties.get("dataset"), scenarioContext);
        if (dataset.isEmpty()) {
            throw new IllegalArgumentException("Step iteration cannot have empty dataset");
        }
        return dataset.stream().map(iterationData -> iterationData.entrySet().stream().map(e -> Map.entry((String)e.getKey(), evaluator.evaluate(e.getValue(), scenarioContext))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).toList();
    }

    private Pair<Step, Map<String, Object>> buildParentIteration(String indexName, Integer index, Step step, List<Step> subSteps, Map<String, Object> iterationContext) {
        StepDefinition newDef = this.iterationDefinition(indexName, index, step.definition(), new StepStrategyDefinition("", new StrategyProperties()));
        List<Step> newSubSteps = subSteps.stream().map(subStep -> this.buildIterationDefinition(indexName, index, subStep.dataEvaluator(), subStep.definition(), subStep.executor(), subStep.subSteps(), subStep.strategy().orElse(new StepStrategyDefinition("", new StrategyProperties())))).toList();
        return Pair.of((Object)new Step(step.dataEvaluator(), newDef, step.executor(), newSubSteps), iterationContext);
    }

    private Pair<Step, Map<String, Object>> buildIteration(String indexName, Integer index, Step step, Map<String, Object> iterationContext) {
        return Pair.of((Object)new Step(step.dataEvaluator(), this.iterationDefinition(indexName, index, step.definition(), new StepStrategyDefinition("", new StrategyProperties())), step.executor(), Collections.emptyList()), iterationContext);
    }

    private Step buildIterationDefinition(String indexName, Integer index, StepDataEvaluator dataEvaluator, StepDefinition definition, StepExecutor executor, List<Step> subStep, StepStrategyDefinition strategy) {
        StepDefinition iterationDefinition = this.iterationDefinition(indexName, index, definition, Optional.ofNullable(strategy).orElse(new StepStrategyDefinition("", new StrategyProperties())));
        return new Step(dataEvaluator, iterationDefinition, executor, subStep.stream().map(step -> this.buildIterationDefinition(indexName, index, step.dataEvaluator(), step.definition(), step.executor(), step.subSteps(), step.strategy().orElse(null))).collect(Collectors.toList()));
    }

    private StepDefinition iterationDefinition(String indexName, Integer index, StepDefinition definition, StepStrategyDefinition strategyDefinition) {
        return StepDefinitionBuilder.copyFrom(definition).withName(this.index(indexName, index, definition.name)).withInputs(this.index(indexName, index, definition.inputs())).withOutputs(this.index(indexName, index, definition.outputs)).withValidations(this.index(indexName, index, definition.validations)).withStrategy(strategyDefinition).withSteps(definition.steps.stream().map(subStep -> this.iterationDefinition(indexName, index, (StepDefinition)subStep, subStep.getStrategy().orElse(new StepStrategyDefinition("", new StrategyProperties())))).toList()).build();
    }

    private String index(String indexName, Integer index, String string) {
        return string.replace("<" + indexName + ">", index.toString());
    }

    private Map<String, Object> index(String indexName, Integer index, Map<String, Object> inputs) {
        return inputs.entrySet().stream().collect(Collectors.toMap(e -> this.index(indexName, index, (String)e.getKey()), e -> this.index(indexName, index, e.getValue())));
    }

    private List<Object> index(String indexName, Integer index, List<Object> inputs) {
        return inputs.stream().map(e -> this.index(indexName, index, e)).toList();
    }

    private Object index(String indexName, Integer index, Object value) {
        if (value instanceof Map) {
            return this.index(indexName, index, (Map)value);
        }
        if (value instanceof List) {
            return this.index(indexName, index, (List)value);
        }
        if (value instanceof String) {
            return this.index(indexName, index, (String)value);
        }
        return value;
    }
}

