/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.report;

import fr.enedis.chutney.engine.domain.execution.RxBus;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.event.BeginStepExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.EndScenarioExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.EndStepExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.Event;
import fr.enedis.chutney.engine.domain.execution.event.PauseStepExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.StartScenarioExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.report.Status;
import fr.enedis.chutney.engine.domain.execution.report.StepExecutionReport;
import fr.enedis.chutney.engine.domain.execution.report.StepExecutionReportBuilder;
import fr.enedis.chutney.engine.domain.execution.strategies.StepStrategyDefinition;
import fr.enedis.chutney.engine.domain.report.CannotGenerateReportException;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.ReplaySubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reporter.class);
    private static final long DEFAULT_RETENTION_DELAY_SECONDS = 5L;
    private final Map<Long, Subject<StepExecutionReport>> reportsPublishers = new ConcurrentHashMap<Long, Subject<StepExecutionReport>>();
    private final Map<Long, Step> rootSteps = new ConcurrentHashMap<Long, Step>();
    private long retentionDelaySeconds;

    public Reporter() {
        this(5L);
    }

    public Reporter(long retentionDelaySeconds) {
        this.retentionDelaySeconds = retentionDelaySeconds;
        this.busRegistration();
    }

    public Observable<StepExecutionReport> subscribeOnExecution(Long executionId) {
        LOGGER.trace("Subscribe for execution {}", (Object)executionId);
        return Optional.ofNullable((Observable)this.reportsPublishers.get(executionId)).orElseGet(Observable::empty);
    }

    public void setRetentionDelaySeconds(long retentionDelaySeconds) {
        this.retentionDelaySeconds = retentionDelaySeconds;
    }

    public void createPublisher(Long executionId, Step rootStep) {
        LOGGER.trace("Create publisher for execution {}", (Object)executionId);
        this.reportsPublishers.put(executionId, (Subject<StepExecutionReport>)ReplaySubject.createWithSize((int)1).toSerialized());
        this.rootSteps.put(executionId, rootStep);
        LOGGER.debug("Publishers map size : {}", (Object)this.reportsPublishers.size());
    }

    private void storeRootStepAndPublishReport(StartScenarioExecutionEvent event) {
        LOGGER.trace("Store root step for execution {}", (Object)event.executionId());
        this.rootSteps.put(event.executionId(), event.step);
        this.publishReport(event);
    }

    private void publishReport(Event event) {
        LOGGER.trace("Publish report for execution {}", (Object)event.executionId());
        this.doIfPublisherExists(event.executionId(), observer -> {
            try {
                observer.onNext((Object)this.generateRunningReport(event.executionId()));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to generate report for execution {}", (Object)event.executionId(), (Object)e);
            }
        });
    }

    private void publishLastReport(Event event) {
        LOGGER.trace("Publish report for execution {}", (Object)event.executionId());
        this.doIfPublisherExists(event.executionId(), observer -> {
            try {
                observer.onNext((Object)this.generateLastReport(event.executionId()));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to generate report for execution {}", (Object)event.executionId(), (Object)e);
            }
        });
    }

    private void publishReportAndCompletePublisher(Event event) {
        this.doIfPublisherExists(event.executionId(), observer -> {
            this.publishLastReport(event);
            this.completePublisher(event.executionId(), (Observer<StepExecutionReport>)observer);
        });
    }

    private StepExecutionReport generateRunningReport(long executionId) throws CannotGenerateReportException {
        Step step = this.rootSteps.get(executionId);
        Status calculatedRootStepStatus = step.status();
        Status finalStatus = !calculatedRootStepStatus.equals((Object)Status.RUNNING) && !calculatedRootStepStatus.equals((Object)Status.PAUSED) ? Status.RUNNING : calculatedRootStepStatus;
        return this.generateReport(step, s -> finalStatus, Reporter.getEnvironment(step));
    }

    private StepExecutionReport generateLastReport(long executionId) throws CannotGenerateReportException {
        Step step = this.rootSteps.get(executionId);
        return this.generateReport(step, Step::status, Reporter.getEnvironment(step));
    }

    private static String getEnvironment(Step step) {
        if (step.isParentStep()) {
            return Reporter.getEnvironment(step.subSteps().getFirst());
        }
        return (String)step.getScenarioContext().get("environment");
    }

    StepExecutionReport generateReport(Step step, Function<Step, Status> statusSupplier, String env) throws CannotGenerateReportException {
        if (step == null) {
            throw new CannotGenerateReportException("Cannot generate report: Step is null.");
        }
        ArrayList<Step> subStepsCopy = new ArrayList<Step>(step.subSteps());
        try {
            return new StepExecutionReportBuilder().setName(step.name()).setEnvironment(env).setDuration(step.duration().toMillis()).setStartDate(step.startDate()).setStatus(statusSupplier.apply(step)).setInformation(step.informations()).setErrors(step.errors()).setSteps(subStepsCopy.stream().map(subStep -> this.generateReport((Step)subStep, Step::status, env)).collect(Collectors.toList())).setEvaluatedInputs(step.getEvaluatedInputs()).setStepResults(step.getStepOutputs()).setEvaluatedInputsSnapshot(step.getStepContextInputSnapshot()).setStepResultsSnapshot(step.getStepContextOutputSnapshot()).setScenarioContext(step.getScenarioContext()).setType(step.type()).setTarget(step.target()).setStrategy(this.guardNullStrategy(step.strategy())).createStepExecutionReport();
        }
        catch (CannotGenerateReportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotGenerateReportException("Unexpected error while generating report for step " + step.name(), e);
        }
    }

    private String guardNullStrategy(Optional<StepStrategyDefinition> strategy) {
        return strategy.map(stepStrategyDefinition -> stepStrategyDefinition.type).orElse(null);
    }

    private void completePublisher(long executionId, Observer<StepExecutionReport> observer) {
        LOGGER.trace("Complete publisher for execution {}", (Object)executionId);
        observer.onComplete();
        if (this.retentionDelaySeconds > 0L) {
            Completable.timer((long)this.retentionDelaySeconds, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.io()).subscribe(() -> {
                this.rootSteps.remove(executionId);
                this.reportsPublishers.remove(executionId);
                LOGGER.trace("Remove publisher for execution {}", (Object)executionId);
            }, throwable -> LOGGER.error("Cannot remove publisher for execution {}", (Object)executionId, throwable));
        } else {
            this.rootSteps.remove(executionId);
            this.reportsPublishers.remove(executionId);
            LOGGER.trace("Remove publisher for execution {}", (Object)executionId);
        }
    }

    private void doIfPublisherExists(long executionId, Consumer<Observer<StepExecutionReport>> consumer) {
        Optional.ofNullable((Observer)this.reportsPublishers.get(executionId)).ifPresent(consumer);
    }

    private void busRegistration() {
        RxBus bus = RxBus.getInstance();
        bus.register(StartScenarioExecutionEvent.class, this::storeRootStepAndPublishReport);
        bus.register(BeginStepExecutionEvent.class, this::publishReport);
        bus.register(EndStepExecutionEvent.class, this::publishReport);
        bus.register(PauseStepExecutionEvent.class, this::publishReport);
        bus.register(EndScenarioExecutionEvent.class, this::publishReportAndCompletePublisher);
    }
}

