/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.infrastructure.delegation;

import fr.enedis.chutney.engine.api.execution.EnvironmentDtoMapper;
import fr.enedis.chutney.engine.api.execution.ExecutionRequestDto;
import fr.enedis.chutney.engine.api.execution.TargetExecutionDto;
import fr.enedis.chutney.engine.domain.environment.TargetImpl;
import fr.enedis.chutney.engine.domain.execution.StepDefinition;
import fr.enedis.chutney.engine.domain.execution.engine.Dataset;
import fr.enedis.chutney.engine.domain.execution.engine.Environment;
import fr.enedis.chutney.engine.infrastructure.delegation.DatasetMapper;
import java.util.List;
import java.util.stream.Collectors;

class ExecutionRequestMapper {
    ExecutionRequestMapper() {
    }

    static ExecutionRequestDto from(StepDefinition stepDefinition, Dataset dataset, Environment environment) {
        ExecutionRequestDto.StepDefinitionRequestDto stepDefinitionRequestDto = ExecutionRequestMapper.getStepDefinitionRequestFromStepDef(stepDefinition);
        return new ExecutionRequestDto(stepDefinitionRequestDto, EnvironmentDtoMapper.INSTANCE.fromDomain(environment), DatasetMapper.toDto(dataset));
    }

    private static ExecutionRequestDto.StepDefinitionRequestDto getStepDefinitionRequestFromStepDef(StepDefinition definition) {
        ExecutionRequestDto.StepStrategyDefinitionRequestDto strategy = definition.getStrategy().map(s -> new ExecutionRequestDto.StepStrategyDefinitionRequestDto(definition.getStrategy().get().type, definition.getStrategy().get().strategyProperties)).orElse(null);
        List<ExecutionRequestDto.StepDefinitionRequestDto> steps = definition.steps.stream().map(ExecutionRequestMapper::getStepDefinitionRequestFromStepDef).collect(Collectors.toList());
        return new ExecutionRequestDto.StepDefinitionRequestDto(definition.name, ExecutionRequestMapper.extractTarget(definition), strategy, definition.type, definition.inputs(), steps, definition.outputs, definition.validations);
    }

    private static TargetExecutionDto extractTarget(StepDefinition definition) {
        return definition.getTarget().map(t -> (TargetImpl)t).map(t -> new TargetExecutionDto(t.name(), t.uri().toString(), t.properties, t.agents)).orElse(null);
    }
}

