/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.infrastructure.delegation;

import fr.enedis.chutney.engine.domain.delegation.ConnectionChecker;
import fr.enedis.chutney.engine.domain.delegation.NamedHostAndPort;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpConnectionChecker
implements ConnectionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpConnectionChecker.class);
    private static final int TIMEOUT = 1000;

    TcpConnectionChecker() {
    }

    @Override
    public boolean canConnectTo(NamedHostAndPort namedHostAndPort) {
        boolean reached = false;
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(namedHostAndPort.host(), namedHostAndPort.port()), 1000);
            reached = true;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to connect to {} ({}: {})", new Object[]{namedHostAndPort, e.getClass().getSimpleName(), e.getMessage()});
        }
        return reached;
    }
}

