/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.environment.api;

import fr.enedis.chutney.environment.domain.exception.AlreadyExistingEnvironmentException;
import fr.enedis.chutney.environment.domain.exception.AlreadyExistingTargetException;
import fr.enedis.chutney.environment.domain.exception.EnvVariableNotFoundException;
import fr.enedis.chutney.environment.domain.exception.EnvironmentNotFoundException;
import fr.enedis.chutney.environment.domain.exception.InvalidEnvironmentNameException;
import fr.enedis.chutney.environment.domain.exception.SingleEnvironmentException;
import fr.enedis.chutney.environment.domain.exception.TargetNotFoundException;
import fr.enedis.chutney.environment.domain.exception.VariableAlreadyExistingException;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class EnvironmentRestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentRestExceptionHandler.class);

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        LOGGER.warn(ex.getMessage());
        return super.handleHttpMessageNotReadable(ex, headers, status, request);
    }

    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        LOGGER.warn(ex.getMessage());
        return super.handleHttpMessageNotWritable(ex, headers, status, request);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<Object> _500(RuntimeException ex, WebRequest request) {
        LOGGER.error("Controller global exception handler", (Throwable)ex);
        String bodyOfResponse = ex.getMessage();
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
    }

    @ExceptionHandler(value={TargetNotFoundException.class, EnvironmentNotFoundException.class, EnvVariableNotFoundException.class})
    protected ResponseEntity<Object> notFound(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = ex.getMessage();
        LOGGER.warn("Not found >> " + bodyOfResponse);
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), (HttpStatusCode)HttpStatus.NOT_FOUND, request);
    }

    @ExceptionHandler(value={AlreadyExistingTargetException.class, AlreadyExistingEnvironmentException.class, VariableAlreadyExistingException.class, SingleEnvironmentException.class})
    protected ResponseEntity<Object> conflict(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = ex.getMessage();
        LOGGER.warn("Conflict >> " + bodyOfResponse);
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), (HttpStatusCode)HttpStatus.CONFLICT, request);
    }

    @ExceptionHandler(value={DateTimeParseException.class, InvalidEnvironmentNameException.class})
    protected ResponseEntity<Object> badRequest(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = ex.getMessage();
        LOGGER.warn("Bad request >> " + bodyOfResponse);
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> forbidden(RuntimeException ex, WebRequest request) {
        String bodyOfResponse = ex.getMessage();
        LOGGER.warn("Forbidden >> " + bodyOfResponse);
        return this.handleExceptionInternal(ex, bodyOfResponse, new HttpHeaders(), (HttpStatusCode)HttpStatus.FORBIDDEN, request);
    }
}

