/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.environment.api.target.dto;

import fr.enedis.chutney.environment.domain.Target;
import fr.enedis.chutney.tools.Entry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TargetDto {
    public final String name;
    public final String url;
    public final String environment;
    public final Set<Entry> properties;

    public TargetDto() {
        this(null, null, null, null);
    }

    public TargetDto(String name, String url, Set<Entry> properties) {
        this(name, url, null, properties);
    }

    public TargetDto(String name, String url, String environment, Set<Entry> properties) {
        this.name = this.trimIfNotNull(name);
        this.url = this.trimIfNotNull(url);
        this.environment = this.trimIfNotNull(environment);
        this.properties = this.nullToEmpty(properties);
    }

    public Target toTarget(String environment) {
        return Target.builder().withName(this.name).withEnvironment(environment).withUrl(this.url).withProperties(this.propertiesToMap()).build();
    }

    public Target toTarget() {
        return Target.builder().withName(this.name).withEnvironment(this.environment).withUrl(this.url).withProperties(this.propertiesToMap()).build();
    }

    public static TargetDto from(Target target) {
        return new TargetDto(target.name, target.url, target.environment, Entry.toEntrySet(target.properties));
    }

    public Map<String, String> propertiesToMap() {
        return this.properties == null ? Collections.emptyMap() : this.properties.stream().collect(Collectors.toMap(p -> p.key, p -> p.value));
    }

    private <T> Set<T> nullToEmpty(Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }

    private String trimIfNotNull(String environment) {
        return environment != null ? environment.trim() : null;
    }
}

