/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.environment.api.variable;

import fr.enedis.chutney.environment.api.variable.EnvironmentVariableApi;
import fr.enedis.chutney.environment.api.variable.dto.EnvironmentVariableDto;
import fr.enedis.chutney.environment.domain.exception.EnvVariableNotFoundException;
import fr.enedis.chutney.environment.domain.exception.EnvironmentNotFoundException;
import fr.enedis.chutney.environment.domain.exception.VariableAlreadyExistingException;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EnvironmentVariableController
implements EnvironmentVariableApi {
    private final String BASE_URI = "/api/v2/variables";
    private final EnvironmentVariableApi delegate;

    public EnvironmentVariableController(EnvironmentVariableApi delegate) {
        this.delegate = delegate;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={"/api/v2/variables"})
    public void addVariable(@RequestBody List<EnvironmentVariableDto> values) throws EnvironmentNotFoundException, VariableAlreadyExistingException {
        this.delegate.addVariable(values);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PutMapping(value={"/api/v2/variables/{key}"})
    public void updateVariable(@PathVariable(value="key") String key, @RequestBody List<EnvironmentVariableDto> values) throws EnvironmentNotFoundException, EnvVariableNotFoundException {
        this.delegate.updateVariable(key, values);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/api/v2/variables/{key}"})
    public void deleteVariable(@PathVariable(value="key") String key) throws EnvVariableNotFoundException {
        this.delegate.deleteVariable(key);
    }
}

