/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.environment.domain;

import fr.enedis.chutney.environment.domain.EnvironmentVariable;
import fr.enedis.chutney.environment.domain.Target;
import fr.enedis.chutney.environment.domain.exception.AlreadyExistingTargetException;
import fr.enedis.chutney.environment.domain.exception.EnvVariableNotFoundException;
import fr.enedis.chutney.environment.domain.exception.TargetNotFoundException;
import fr.enedis.chutney.environment.domain.exception.VariableAlreadyExistingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Environment {
    public final String name;
    public final String description;
    public final Set<Target> targets;
    public final Set<EnvironmentVariable> variables;

    private Environment(String name, String description, Set<Target> targets, Set<EnvironmentVariable> variables) {
        this.name = name;
        this.description = description;
        this.targets = targets;
        this.variables = variables;
    }

    public static EnvironmentBuilder builder() {
        return new EnvironmentBuilder();
    }

    Environment addTarget(Target target) {
        if (this.containsTarget(target)) {
            throw new AlreadyExistingTargetException(target.name, this.name);
        }
        return Environment.builder().from(this).addTarget(target).build();
    }

    private boolean containsTarget(Target target) {
        return this.targets.stream().anyMatch(t -> t.name.equalsIgnoreCase(target.name));
    }

    boolean containsVariable(String key) {
        return this.variables.stream().anyMatch(t -> t.key().equalsIgnoreCase(key));
    }

    Target getTarget(String targetName) {
        return this.targets.stream().filter(t -> t.name.equals(targetName)).findFirst().orElseThrow(() -> new TargetNotFoundException("Target [" + targetName + "] not found in environment [" + this.name + "]"));
    }

    Environment deleteTarget(String targetName) {
        Optional<Target> targetToRemove = this.targets.stream().filter(t -> t.name.equals(targetName)).findFirst();
        return targetToRemove.map(t -> {
            HashSet<Target> updatedTargets = new HashSet<Target>(this.targets);
            updatedTargets.remove(t);
            return Environment.builder().from(this).withTargets(updatedTargets).build();
        }).orElseThrow(() -> new TargetNotFoundException("Target [" + targetName + "] not found in environment [" + this.name + "]"));
    }

    Environment updateTarget(String targetName, Target targetToUpdate) {
        Optional<Target> previousTarget = this.targets.stream().filter(t -> t.name.equals(targetName)).findFirst();
        return previousTarget.map(t -> {
            if (((Target)previousTarget.get()).equals(targetToUpdate)) {
                return this;
            }
            HashSet<Target> updatedTargets = new HashSet<Target>(this.targets);
            updatedTargets.remove(t);
            updatedTargets.add(targetToUpdate);
            return Environment.builder().from(this).withTargets(updatedTargets).build();
        }).orElseThrow(() -> new TargetNotFoundException("Target [" + targetName + "] not found in environment [" + this.name + "]"));
    }

    Environment addVariable(EnvironmentVariable variable) {
        if (this.containsVariable(variable.key())) {
            throw new VariableAlreadyExistingException("Variable [" + variable.key() + "] already exists in [" + this.name + "] environment");
        }
        return Environment.builder().from(this).addVariable(variable).build();
    }

    Environment updateVariable(String oldKey, EnvironmentVariable variable) {
        Optional<EnvironmentVariable> oldVariable = this.variables.stream().filter(t -> t.key().equalsIgnoreCase(oldKey)).findFirst();
        oldVariable.orElseThrow(() -> new EnvVariableNotFoundException("Variable [" + oldKey + "] not found in environment [" + this.name + "]"));
        if (!oldVariable.get().equals(variable)) {
            HashSet<EnvironmentVariable> updatedVariables = new HashSet<EnvironmentVariable>(this.variables);
            updatedVariables.remove(oldVariable.get());
            updatedVariables.add(variable);
            return Environment.builder().from(this).withVariables(updatedVariables).build();
        }
        return this;
    }

    Environment deleteVariable(String key) {
        Optional<EnvironmentVariable> variable = this.variables.stream().filter(t -> t.key().equalsIgnoreCase(key)).findFirst();
        if (variable.isEmpty()) {
            return this;
        }
        HashSet<EnvironmentVariable> updatedVariables = new HashSet<EnvironmentVariable>(this.variables);
        updatedVariables.remove(variable.get());
        return Environment.builder().from(this).withVariables(updatedVariables).build();
    }

    public String toString() {
        return "Environment{name='" + this.name + "', description='" + this.description + "', targets=" + String.valueOf(this.targets) + ", variables=" + String.valueOf(this.variables) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.targets, that.targets) && Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.targets, this.variables);
    }

    public static class EnvironmentBuilder {
        private String name;
        private String description;
        private Set<Target> targets = new HashSet<Target>();
        private Set<EnvironmentVariable> variables = new HashSet<EnvironmentVariable>();

        private EnvironmentBuilder() {
        }

        public Environment build() {
            return new Environment(Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.targets).map(Collections::unmodifiableSet).orElse(Collections.emptySet()), Optional.ofNullable(this.variables).map(Collections::unmodifiableSet).orElse(Collections.emptySet()));
        }

        public EnvironmentBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public EnvironmentBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public EnvironmentBuilder withTargets(Set<Target> targetSet) {
            this.targets = new HashSet<Target>(targetSet);
            return this;
        }

        public EnvironmentBuilder withVariables(Set<EnvironmentVariable> variables) {
            this.variables = new HashSet<EnvironmentVariable>(variables);
            return this;
        }

        public EnvironmentBuilder addTarget(Target target) {
            this.targets.add(target);
            return this;
        }

        public EnvironmentBuilder addVariable(EnvironmentVariable variable) {
            this.variables.add(variable);
            return this;
        }

        public EnvironmentBuilder from(Environment environment) {
            this.name = environment.name;
            this.description = environment.description;
            this.targets = new HashSet<Target>(environment.targets);
            this.variables = new HashSet<EnvironmentVariable>(environment.variables);
            return this;
        }
    }
}

