/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.environment.domain;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Target {
    public final String url;
    public final Map<String, String> properties;
    public final String name;
    public final String environment;

    private Target(String environment, String url, Map<String, String> properties, String name) {
        this.environment = environment;
        this.url = url;
        this.properties = properties;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static TargetBuilder builder() {
        return new TargetBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Target target = (Target)o;
        return Objects.equals(this.environment, target.environment) && Objects.equals(this.url, target.url) && Objects.equals(this.properties, target.properties) && Objects.equals(this.name, target.name);
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.url, this.properties, this.name);
    }

    public String toString() {
        return "Target{environment=" + this.environment + ", url='" + this.url + "', properties=" + String.valueOf(this.properties) + ", name='" + this.name + "'}";
    }

    public static class TargetBuilder {
        private String name;
        private String environment;
        private String url;
        private Map<String, String> properties = new HashMap<String, String>();

        private TargetBuilder() {
        }

        public Target build() {
            return new Target(Objects.requireNonNull(this.environment, "environment"), Objects.requireNonNull(this.url, "url"), Collections.unmodifiableMap(Optional.ofNullable(this.properties).orElse(Collections.emptyMap())), Objects.requireNonNull(this.name, "name"));
        }

        public TargetBuilder withName(String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        public TargetBuilder withEnvironment(String value) {
            this.environment = Objects.requireNonNull(value, "environment");
            return this;
        }

        public TargetBuilder withUrl(String value) {
            this.url = Objects.requireNonNull(value, "url");
            return this;
        }

        public TargetBuilder withProperties(Map<String, String> value) {
            this.properties.putAll(value);
            return this;
        }

        public TargetBuilder withProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public TargetBuilder withProperty(Map.Entry<String, String> entry) {
            this.properties.put(entry.getKey(), entry.getValue());
            return this;
        }

        public TargetBuilder copyOf(Target target) {
            Objects.requireNonNull(target, "target");
            this.withName(target.name);
            this.withEnvironment(target.environment);
            this.withUrl(target.url);
            this.withProperties(target.properties);
            return this;
        }
    }
}

