/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.environment.infra;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import fr.enedis.chutney.environment.domain.Environment;
import fr.enedis.chutney.environment.domain.EnvironmentRepository;
import fr.enedis.chutney.environment.domain.EnvironmentVariable;
import fr.enedis.chutney.environment.domain.Target;
import fr.enedis.chutney.environment.domain.exception.CannotDeleteEnvironmentException;
import fr.enedis.chutney.environment.domain.exception.EnvironmentNotFoundException;
import fr.enedis.chutney.environment.domain.exception.InvalidEnvironmentNameException;
import fr.enedis.chutney.environment.domain.exception.TargetAlreadyExistsException;
import fr.enedis.chutney.environment.domain.exception.VariableAlreadyExistingException;
import fr.enedis.chutney.environment.infra.JsonEnvironment;
import fr.enedis.chutney.tools.file.FileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class JsonFilesEnvironmentRepository
implements EnvironmentRepository {
    private static final String JSON_FILE_EXT = ".json";
    private final Path storeFolderPath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public JsonFilesEnvironmentRepository(String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).toAbsolutePath();
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    @Override
    public synchronized void save(Environment environment) throws UnsupportedOperationException, InvalidEnvironmentNameException {
        this.doSave(environment);
    }

    @Override
    public Environment findByName(String name) throws EnvironmentNotFoundException {
        Path environmentPath = this.getEnvironmentPath(name);
        if (!Files.exists(environmentPath, new LinkOption[0])) {
            throw new EnvironmentNotFoundException(environmentPath);
        }
        try {
            byte[] bytes = Files.readAllBytes(environmentPath);
            try {
                return ((JsonEnvironment)this.objectMapper.readValue(bytes, JsonEnvironment.class)).toEnvironment();
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot deserialize configuration file: " + String.valueOf(environmentPath), e);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + String.valueOf(environmentPath), e);
        }
    }

    @Override
    public List<String> listNames() throws UnsupportedOperationException {
        return (List)FileUtils.doOnListFiles((Path)this.storeFolderPath, pathStream -> pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::isJsonFile).map(FileUtils::getNameWithoutExtension).collect(Collectors.toList()));
    }

    private boolean isJsonFile(Path path) {
        return path.getFileName().toString().endsWith(JSON_FILE_EXT);
    }

    @Override
    public void delete(String name) {
        Path environmentPath = this.getEnvironmentPath(name);
        if (!Files.exists(environmentPath, new LinkOption[0])) {
            throw new EnvironmentNotFoundException(environmentPath);
        }
        try {
            Path backupPath = Paths.get(environmentPath.toString() + UUID.randomUUID().getMostSignificantBits() + ".backup", new String[0]);
            Files.move(environmentPath, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new CannotDeleteEnvironmentException(environmentPath, e);
        }
    }

    private void doSave(Environment environment) {
        Path environmentPath = this.getEnvironmentPath(environment.name);
        this.checkTargetNameUnicity(environment.targets);
        this.checkVariableNameUnicity(environment.variables);
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)JsonEnvironment.from(environment));
            try {
                Files.write(environmentPath, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write in configuration directory: " + String.valueOf(this.storeFolderPath), e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + String.valueOf(environment), e);
        }
    }

    private void checkTargetNameUnicity(Set<Target> targets) {
        Set notUniqueTargets = targets.stream().collect(Collectors.groupingBy(Target::getName, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!notUniqueTargets.isEmpty()) {
            throw new TargetAlreadyExistsException("Targets are not unique : " + String.join((CharSequence)", ", notUniqueTargets));
        }
    }

    private void checkVariableNameUnicity(Set<EnvironmentVariable> variables) {
        Set notUniqueVariables = variables.stream().collect(Collectors.groupingBy(EnvironmentVariable::key, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!notUniqueVariables.isEmpty()) {
            throw new VariableAlreadyExistingException("Variables are not unique : " + String.join((CharSequence)", ", notUniqueVariables));
        }
    }

    public Path getEnvironmentPath(String name) {
        return this.storeFolderPath.resolve(name + JSON_FILE_EXT);
    }
}

