
package fr.enedis.chutney.jira.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JiraScenarioLinksDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJiraScenarioLinksDto.builder()}.
 */
@Generated(from = "JiraScenarioLinksDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJiraScenarioLinksDto implements JiraScenarioLinksDto {
  private final @Nullable String id;
  private final String chutneyId;
  private final Map<String, String> datasetLinks;

  private ImmutableJiraScenarioLinksDto(ImmutableJiraScenarioLinksDto.Builder builder) {
    this.id = builder.id;
    this.chutneyId = builder.chutneyId;
    this.datasetLinks = builder.datasetLinksIsSet()
        ? createUnmodifiableMap(false, false, builder.datasetLinks)
        : createUnmodifiableMap(true, false, JiraScenarioLinksDto.super.datasetLinks());
  }

  private ImmutableJiraScenarioLinksDto(
      @Nullable String id,
      String chutneyId,
      Map<String, String> datasetLinks) {
    this.id = id;
    this.chutneyId = chutneyId;
    this.datasetLinks = datasetLinks;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "id")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * @return The value of the {@code chutneyId} attribute
   */
  @JsonProperty(value = "chutneyId", required = true)
  @Override
  public String chutneyId() {
    return chutneyId;
  }

  /**
   * @return The value of the {@code datasetLinks} attribute
   */
  @JsonProperty(value = "datasetLinks", required = true)
  @Override
  public Map<String, String> datasetLinks() {
    return datasetLinks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraScenarioLinksDto#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableJiraScenarioLinksDto withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableJiraScenarioLinksDto(value, this.chutneyId, this.datasetLinks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JiraScenarioLinksDto#chutneyId() chutneyId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for chutneyId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableJiraScenarioLinksDto withChutneyId(String value) {
    String newValue = Objects.requireNonNull(value, "chutneyId");
    if (this.chutneyId.equals(newValue)) return this;
    return new ImmutableJiraScenarioLinksDto(this.id, newValue, this.datasetLinks);
  }

  /**
   * Copy the current immutable object by replacing the {@link JiraScenarioLinksDto#datasetLinks() datasetLinks} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the datasetLinks map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableJiraScenarioLinksDto withDatasetLinks(Map<String, ? extends String> entries) {
    if (this.datasetLinks == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableJiraScenarioLinksDto(this.id, this.chutneyId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJiraScenarioLinksDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJiraScenarioLinksDto
        && equalsByValue((ImmutableJiraScenarioLinksDto) another);
  }

  private boolean equalsByValue(ImmutableJiraScenarioLinksDto another) {
    return Objects.equals(id, another.id)
        && chutneyId.equals(another.chutneyId)
        && datasetLinks.equals(another.datasetLinks);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code chutneyId}, {@code datasetLinks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + chutneyId.hashCode();
    h += (h << 5) + datasetLinks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JiraScenarioLinksDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JiraScenarioLinksDto{"
        + "id=" + id
        + ", chutneyId=" + chutneyId
        + ", datasetLinks=" + datasetLinks
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JiraScenarioLinksDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements JiraScenarioLinksDto {
    @JsonIgnore @Nullable String id;
    @JsonIgnore @Nullable String chutneyId;
    @JsonIgnore @Nullable Map<String, String> datasetLinks = Collections.emptyMap();
    @JsonIgnore boolean datasetLinksIsSet;

    @JsonProperty(value = "id")
    public void setId(@Nullable String id) {
      this.id = id;
    }

    @JsonProperty(value = "chutneyId", required = true)
    public void setChutneyId(String chutneyId) {
      this.chutneyId = chutneyId;
    }

    @JsonProperty(value = "datasetLinks", required = true)
    public void setDatasetLinks(Map<String, String> datasetLinks) {
      this.datasetLinks = datasetLinks;
      this.datasetLinksIsSet = null != datasetLinks;
    }

    @Override
    public String id() { throw new UnsupportedOperationException(); }

    @Override
    public String chutneyId() { throw new UnsupportedOperationException(); }

    @Override
    public Map<String, String> datasetLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableJiraScenarioLinksDto fromJson(Json json) {
    ImmutableJiraScenarioLinksDto.Builder builder = ImmutableJiraScenarioLinksDto.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.chutneyId != null) {
      builder.chutneyId(json.chutneyId);
    }
    if (json.datasetLinksIsSet) {
      builder.putAllDatasetLinks(json.datasetLinks);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JiraScenarioLinksDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JiraScenarioLinksDto instance
   */
  public static ImmutableJiraScenarioLinksDto copyOf(JiraScenarioLinksDto instance) {
    if (instance instanceof ImmutableJiraScenarioLinksDto) {
      return (ImmutableJiraScenarioLinksDto) instance;
    }
    return ImmutableJiraScenarioLinksDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJiraScenarioLinksDto ImmutableJiraScenarioLinksDto}.
   * <pre>
   * ImmutableJiraScenarioLinksDto.builder()
   *    .id(String | null) // nullable {@link JiraScenarioLinksDto#id() id}
   *    .chutneyId(String) // required {@link JiraScenarioLinksDto#chutneyId() chutneyId}
   *    .putDatasetLinks|putAllDatasetLinks(String =&gt; String) // {@link JiraScenarioLinksDto#datasetLinks() datasetLinks} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableJiraScenarioLinksDto builder
   */
  public static ImmutableJiraScenarioLinksDto.Builder builder() {
    return new ImmutableJiraScenarioLinksDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJiraScenarioLinksDto ImmutableJiraScenarioLinksDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JiraScenarioLinksDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHUTNEY_ID = 0x1L;
    private static final long OPT_BIT_DATASET_LINKS = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String id;
    private @Nullable String chutneyId;
    private Map<String, String> datasetLinks = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JiraScenarioLinksDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JiraScenarioLinksDto instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      this.chutneyId(instance.chutneyId());
      putAllDatasetLinks(instance.datasetLinks());
      return this;
    }

    /**
     * Initializes the value for the {@link JiraScenarioLinksDto#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link JiraScenarioLinksDto#chutneyId() chutneyId} attribute.
     * @param chutneyId The value for chutneyId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "chutneyId", required = true)
    public final Builder chutneyId(String chutneyId) {
      this.chutneyId = Objects.requireNonNull(chutneyId, "chutneyId");
      initBits &= ~INIT_BIT_CHUTNEY_ID;
      return this;
    }

    /**
     * Put one entry to the {@link JiraScenarioLinksDto#datasetLinks() datasetLinks} map.
     * @param key The key in the datasetLinks map
     * @param value The associated value in the datasetLinks map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putDatasetLinks(String key, String value) {
      this.datasetLinks.put(
          Objects.requireNonNull(key, "datasetLinks key"),
          Objects.requireNonNull(value, value == null ? "datasetLinks value for key: " + key : null));
      optBits |= OPT_BIT_DATASET_LINKS;
      return this;
    }

    /**
     * Put one entry to the {@link JiraScenarioLinksDto#datasetLinks() datasetLinks} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putDatasetLinks(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.datasetLinks.put(
          Objects.requireNonNull(k, "datasetLinks key"),
          Objects.requireNonNull(v, v == null ? "datasetLinks value for key: " + k : null));
      optBits |= OPT_BIT_DATASET_LINKS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link JiraScenarioLinksDto#datasetLinks() datasetLinks} map. Nulls are not permitted
     * @param entries The entries that will be added to the datasetLinks map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "datasetLinks", required = true)
    public final Builder datasetLinks(Map<String, ? extends String> entries) {
      this.datasetLinks.clear();
      optBits |= OPT_BIT_DATASET_LINKS;
      return putAllDatasetLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link JiraScenarioLinksDto#datasetLinks() datasetLinks} map. Nulls are not permitted
     * @param entries The entries that will be added to the datasetLinks map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllDatasetLinks(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.datasetLinks.put(
            Objects.requireNonNull(k, "datasetLinks key"),
            Objects.requireNonNull(v, v == null ? "datasetLinks value for key: " + k : null));
      }
      optBits |= OPT_BIT_DATASET_LINKS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJiraScenarioLinksDto ImmutableJiraScenarioLinksDto}.
     * @return An immutable instance of JiraScenarioLinksDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJiraScenarioLinksDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJiraScenarioLinksDto(this);
    }

    private boolean datasetLinksIsSet() {
      return (optBits & OPT_BIT_DATASET_LINKS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CHUTNEY_ID) != 0) attributes.add("chutneyId");
      return "Cannot build JiraScenarioLinksDto, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
