
package fr.enedis.chutney.server.core.domain.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PaginatedDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePaginatedDto.builder()}.
 */
@Generated(from = "PaginatedDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePaginatedDto<PAGINATED_OBJECT>
    implements PaginatedDto<PAGINATED_OBJECT> {
  private final long totalCount;
  private final List<PAGINATED_OBJECT> data;

  private ImmutablePaginatedDto(ImmutablePaginatedDto.Builder<PAGINATED_OBJECT> builder) {
    this.totalCount = builder.totalCount;
    this.data = builder.dataIsSet()
        ? createUnmodifiableList(true, builder.data)
        : createUnmodifiableList(false, createSafeList(PaginatedDto.super.data(), true, false));
  }

  private ImmutablePaginatedDto(long totalCount, List<PAGINATED_OBJECT> data) {
    this.totalCount = totalCount;
    this.data = data;
  }

  /**
   * @return The value of the {@code totalCount} attribute
   */
  @JsonProperty(value = "totalCount", required = true)
  @Override
  public long totalCount() {
    return totalCount;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty(value = "data", required = true)
  @Override
  public List<PAGINATED_OBJECT> data() {
    return data;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PaginatedDto#totalCount() totalCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePaginatedDto<PAGINATED_OBJECT> withTotalCount(long value) {
    if (this.totalCount == value) return this;
    return new ImmutablePaginatedDto<>(value, this.data);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PaginatedDto#data() data}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutablePaginatedDto<PAGINATED_OBJECT> withData(PAGINATED_OBJECT... elements) {
    List<PAGINATED_OBJECT> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePaginatedDto<>(this.totalCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PaginatedDto#data() data}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of data elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePaginatedDto<PAGINATED_OBJECT> withData(Iterable<? extends PAGINATED_OBJECT> elements) {
    if (this.data == elements) return this;
    List<PAGINATED_OBJECT> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePaginatedDto<>(this.totalCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePaginatedDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePaginatedDto<?>
        && equalsByValue((ImmutablePaginatedDto<?>) another);
  }

  private boolean equalsByValue(ImmutablePaginatedDto<?> another) {
    return totalCount == another.totalCount
        && data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Long.hashCode(totalCount);
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PaginatedDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PaginatedDto{"
        + "totalCount=" + totalCount
        + ", data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PaginatedDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json<PAGINATED_OBJECT>
      implements PaginatedDto<PAGINATED_OBJECT> {
    @JsonIgnore long totalCount;
    @JsonIgnore boolean totalCountIsSet;
    @JsonIgnore @Nullable List<PAGINATED_OBJECT> data = Collections.emptyList();
    @JsonIgnore boolean dataIsSet;

    @JsonProperty(value = "totalCount", required = true)
    public void setTotalCount(long totalCount) {
      this.totalCount = totalCount;
      this.totalCountIsSet = true;
    }

    @JsonProperty(value = "data", required = true)
    public void setData(List<PAGINATED_OBJECT> data) {
      this.data = data;
      this.dataIsSet = null != data;
    }

    @Override
    public long totalCount() { throw new UnsupportedOperationException(); }

    @Override
    public List<PAGINATED_OBJECT> data() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <PAGINATED_OBJECT> generic parameter PAGINATED_OBJECT
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static <PAGINATED_OBJECT> ImmutablePaginatedDto<PAGINATED_OBJECT> fromJson(Json<PAGINATED_OBJECT> json) {
    ImmutablePaginatedDto.Builder<PAGINATED_OBJECT> builder = ImmutablePaginatedDto.<PAGINATED_OBJECT>builder();
    if (json.totalCountIsSet) {
      builder.totalCount(json.totalCount);
    }
    if (json.dataIsSet) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PaginatedDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <PAGINATED_OBJECT> generic parameter PAGINATED_OBJECT
   * @param instance The instance to copy
   * @return A copied immutable PaginatedDto instance
   */
  public static <PAGINATED_OBJECT> ImmutablePaginatedDto<PAGINATED_OBJECT> copyOf(PaginatedDto<PAGINATED_OBJECT> instance) {
    if (instance instanceof ImmutablePaginatedDto<?>) {
      return (ImmutablePaginatedDto<PAGINATED_OBJECT>) instance;
    }
    return ImmutablePaginatedDto.<PAGINATED_OBJECT>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePaginatedDto ImmutablePaginatedDto}.
   * <pre>
   * ImmutablePaginatedDto.&lt;PAGINATED_OBJECT&gt;builder()
   *    .totalCount(long) // required {@link PaginatedDto#totalCount() totalCount}
   *    .addData|addAllData(PAGINATED_OBJECT) // {@link PaginatedDto#data() data} elements
   *    .build();
   * </pre>
   * @param <PAGINATED_OBJECT> generic parameter PAGINATED_OBJECT
   * @return A new ImmutablePaginatedDto builder
   */
  public static <PAGINATED_OBJECT> ImmutablePaginatedDto.Builder<PAGINATED_OBJECT> builder() {
    return new ImmutablePaginatedDto.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutablePaginatedDto ImmutablePaginatedDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PaginatedDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<PAGINATED_OBJECT> {
    private static final long INIT_BIT_TOTAL_COUNT = 0x1L;
    private static final long OPT_BIT_DATA = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private long totalCount;
    private List<PAGINATED_OBJECT> data = new ArrayList<PAGINATED_OBJECT>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PaginatedDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<PAGINATED_OBJECT> from(PaginatedDto<PAGINATED_OBJECT> instance) {
      Objects.requireNonNull(instance, "instance");
      this.totalCount(instance.totalCount());
      addAllData(instance.data());
      return this;
    }

    /**
     * Initializes the value for the {@link PaginatedDto#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "totalCount", required = true)
    public final Builder<PAGINATED_OBJECT> totalCount(long totalCount) {
      this.totalCount = totalCount;
      initBits &= ~INIT_BIT_TOTAL_COUNT;
      return this;
    }

    /**
     * Adds one element to {@link PaginatedDto#data() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<PAGINATED_OBJECT> addData(PAGINATED_OBJECT element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      optBits |= OPT_BIT_DATA;
      return this;
    }

    /**
     * Adds elements to {@link PaginatedDto#data() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<PAGINATED_OBJECT> addData(PAGINATED_OBJECT... elements) {
      for (PAGINATED_OBJECT element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      optBits |= OPT_BIT_DATA;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PaginatedDto#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "data", required = true)
    public final Builder<PAGINATED_OBJECT> data(Iterable<? extends PAGINATED_OBJECT> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link PaginatedDto#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<PAGINATED_OBJECT> addAllData(Iterable<? extends PAGINATED_OBJECT> elements) {
      for (PAGINATED_OBJECT element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      optBits |= OPT_BIT_DATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePaginatedDto ImmutablePaginatedDto}.
     * @return An immutable instance of PaginatedDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePaginatedDto<PAGINATED_OBJECT> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePaginatedDto<PAGINATED_OBJECT>(this);
    }

    private boolean dataIsSet() {
      return (optBits & OPT_BIT_DATA) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_COUNT) != 0) attributes.add("totalCount");
      return "Cannot build PaginatedDto, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
