
package fr.enedis.chutney.server.core.domain.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PaginationRequestWrapperDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePaginationRequestWrapperDto.builder()}.
 */
@Generated(from = "PaginationRequestWrapperDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePaginationRequestWrapperDto<W>
    implements PaginationRequestWrapperDto<W> {
  private final Integer pageNumber;
  private final Integer elementPerPage;
  private final Optional<W> wrappedRequest;

  private ImmutablePaginationRequestWrapperDto(ImmutablePaginationRequestWrapperDto.Builder<W> builder) {
    this.pageNumber = builder.pageNumber;
    this.elementPerPage = builder.elementPerPage;
    this.wrappedRequest = builder.wrappedRequest != null
        ? builder.wrappedRequest
        : Objects.requireNonNull(PaginationRequestWrapperDto.super.wrappedRequest(), "wrappedRequest");
  }

  private ImmutablePaginationRequestWrapperDto(
      Integer pageNumber,
      Integer elementPerPage,
      Optional<W> wrappedRequest) {
    this.pageNumber = pageNumber;
    this.elementPerPage = elementPerPage;
    this.wrappedRequest = wrappedRequest;
  }

  /**
   * @return The value of the {@code pageNumber} attribute
   */
  @JsonProperty(value = "pageNumber", required = true)
  @Override
  public Integer pageNumber() {
    return pageNumber;
  }

  /**
   * @return The value of the {@code elementPerPage} attribute
   */
  @JsonProperty(value = "elementPerPage", required = true)
  @Override
  public Integer elementPerPage() {
    return elementPerPage;
  }

  /**
   * @return The value of the {@code wrappedRequest} attribute
   */
  @JsonProperty(value = "wrappedRequest", required = true)
  @Override
  public Optional<W> wrappedRequest() {
    return wrappedRequest;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PaginationRequestWrapperDto#pageNumber() pageNumber} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageNumber
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePaginationRequestWrapperDto<W> withPageNumber(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "pageNumber");
    if (this.pageNumber.equals(newValue)) return this;
    return new ImmutablePaginationRequestWrapperDto<>(newValue, this.elementPerPage, this.wrappedRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PaginationRequestWrapperDto#elementPerPage() elementPerPage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementPerPage
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePaginationRequestWrapperDto<W> withElementPerPage(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "elementPerPage");
    if (this.elementPerPage.equals(newValue)) return this;
    return new ImmutablePaginationRequestWrapperDto<>(this.pageNumber, newValue, this.wrappedRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PaginationRequestWrapperDto#wrappedRequest() wrappedRequest} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrappedRequest
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePaginationRequestWrapperDto<W> withWrappedRequest(Optional<W> value) {
    if (Objects.equals(this.wrappedRequest, value)) return this;
    Optional<W> newValue = Objects.requireNonNull(value, "wrappedRequest");
    return new ImmutablePaginationRequestWrapperDto<>(this.pageNumber, this.elementPerPage, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePaginationRequestWrapperDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePaginationRequestWrapperDto<?>
        && equalsByValue((ImmutablePaginationRequestWrapperDto<?>) another);
  }

  private boolean equalsByValue(ImmutablePaginationRequestWrapperDto<?> another) {
    return pageNumber.equals(another.pageNumber)
        && elementPerPage.equals(another.elementPerPage)
        && wrappedRequest.equals(another.wrappedRequest);
  }

  /**
   * Computes a hash code from attributes: {@code pageNumber}, {@code elementPerPage}, {@code wrappedRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pageNumber.hashCode();
    h += (h << 5) + elementPerPage.hashCode();
    h += (h << 5) + wrappedRequest.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PaginationRequestWrapperDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PaginationRequestWrapperDto{"
        + "pageNumber=" + pageNumber
        + ", elementPerPage=" + elementPerPage
        + ", wrappedRequest=" + wrappedRequest
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PaginationRequestWrapperDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json<W>
      implements PaginationRequestWrapperDto<W> {
    @JsonIgnore @Nullable Integer pageNumber;
    @JsonIgnore @Nullable Integer elementPerPage;
    @JsonIgnore @Nullable Optional<W> wrappedRequest;

    @JsonProperty(value = "pageNumber", required = true)
    public void setPageNumber(Integer pageNumber) {
      this.pageNumber = pageNumber;
    }

    @JsonProperty(value = "elementPerPage", required = true)
    public void setElementPerPage(Integer elementPerPage) {
      this.elementPerPage = elementPerPage;
    }

    @JsonProperty(value = "wrappedRequest", required = true)
    public void setWrappedRequest(Optional<W> wrappedRequest) {
      this.wrappedRequest = wrappedRequest;
    }

    @Override
    public Integer pageNumber() { throw new UnsupportedOperationException(); }

    @Override
    public Integer elementPerPage() { throw new UnsupportedOperationException(); }

    @Override
    public Optional<W> wrappedRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <W> generic parameter W
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static <W> ImmutablePaginationRequestWrapperDto<W> fromJson(Json<W> json) {
    ImmutablePaginationRequestWrapperDto.Builder<W> builder = ImmutablePaginationRequestWrapperDto.<W>builder();
    if (json.pageNumber != null) {
      builder.pageNumber(json.pageNumber);
    }
    if (json.elementPerPage != null) {
      builder.elementPerPage(json.elementPerPage);
    }
    if (json.wrappedRequest != null) {
      builder.wrappedRequest(json.wrappedRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PaginationRequestWrapperDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <W> generic parameter W
   * @param instance The instance to copy
   * @return A copied immutable PaginationRequestWrapperDto instance
   */
  public static <W> ImmutablePaginationRequestWrapperDto<W> copyOf(PaginationRequestWrapperDto<W> instance) {
    if (instance instanceof ImmutablePaginationRequestWrapperDto<?>) {
      return (ImmutablePaginationRequestWrapperDto<W>) instance;
    }
    return ImmutablePaginationRequestWrapperDto.<W>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePaginationRequestWrapperDto ImmutablePaginationRequestWrapperDto}.
   * <pre>
   * ImmutablePaginationRequestWrapperDto.&lt;W&gt;builder()
   *    .pageNumber(Integer) // required {@link PaginationRequestWrapperDto#pageNumber() pageNumber}
   *    .elementPerPage(Integer) // required {@link PaginationRequestWrapperDto#elementPerPage() elementPerPage}
   *    .wrappedRequest(Optional&lt;W&gt;) // optional {@link PaginationRequestWrapperDto#wrappedRequest() wrappedRequest}
   *    .build();
   * </pre>
   * @param <W> generic parameter W
   * @return A new ImmutablePaginationRequestWrapperDto builder
   */
  public static <W> ImmutablePaginationRequestWrapperDto.Builder<W> builder() {
    return new ImmutablePaginationRequestWrapperDto.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutablePaginationRequestWrapperDto ImmutablePaginationRequestWrapperDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PaginationRequestWrapperDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<W> {
    private static final long INIT_BIT_PAGE_NUMBER = 0x1L;
    private static final long INIT_BIT_ELEMENT_PER_PAGE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Integer pageNumber;
    private @Nullable Integer elementPerPage;
    private @Nullable Optional<W> wrappedRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PaginationRequestWrapperDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<W> from(PaginationRequestWrapperDto<W> instance) {
      Objects.requireNonNull(instance, "instance");
      this.pageNumber(instance.pageNumber());
      this.elementPerPage(instance.elementPerPage());
      this.wrappedRequest(instance.wrappedRequest());
      return this;
    }

    /**
     * Initializes the value for the {@link PaginationRequestWrapperDto#pageNumber() pageNumber} attribute.
     * @param pageNumber The value for pageNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "pageNumber", required = true)
    public final Builder<W> pageNumber(Integer pageNumber) {
      this.pageNumber = Objects.requireNonNull(pageNumber, "pageNumber");
      initBits &= ~INIT_BIT_PAGE_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PaginationRequestWrapperDto#elementPerPage() elementPerPage} attribute.
     * @param elementPerPage The value for elementPerPage 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "elementPerPage", required = true)
    public final Builder<W> elementPerPage(Integer elementPerPage) {
      this.elementPerPage = Objects.requireNonNull(elementPerPage, "elementPerPage");
      initBits &= ~INIT_BIT_ELEMENT_PER_PAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link PaginationRequestWrapperDto#wrappedRequest() wrappedRequest} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PaginationRequestWrapperDto#wrappedRequest() wrappedRequest}.</em>
     * @param wrappedRequest The value for wrappedRequest 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "wrappedRequest", required = true)
    public final Builder<W> wrappedRequest(Optional<W> wrappedRequest) {
      this.wrappedRequest = Objects.requireNonNull(wrappedRequest, "wrappedRequest");
      return this;
    }

    /**
     * Builds a new {@link ImmutablePaginationRequestWrapperDto ImmutablePaginationRequestWrapperDto}.
     * @return An immutable instance of PaginationRequestWrapperDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePaginationRequestWrapperDto<W> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePaginationRequestWrapperDto<W>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PAGE_NUMBER) != 0) attributes.add("pageNumber");
      if ((initBits & INIT_BIT_ELEMENT_PER_PAGE) != 0) attributes.add("elementPerPage");
      return "Cannot build PaginationRequestWrapperDto, some of required attributes are not set " + attributes;
    }
  }
}
