/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import fr.enedis.chutney.ExecutionConfiguration;
import fr.enedis.chutney.action.api.EmbeddedActionEngine;
import fr.enedis.chutney.campaign.domain.CampaignEnvironmentUpdateHandler;
import fr.enedis.chutney.campaign.domain.CampaignExecutionRepository;
import fr.enedis.chutney.campaign.domain.CampaignRepository;
import fr.enedis.chutney.campaign.domain.CampaignService;
import fr.enedis.chutney.dataset.domain.DataSetRepository;
import fr.enedis.chutney.design.domain.editionlock.TestCaseEditions;
import fr.enedis.chutney.design.domain.editionlock.TestCaseEditionsService;
import fr.enedis.chutney.engine.api.execution.TestEngine;
import fr.enedis.chutney.execution.domain.campaign.CampaignExecutionEngine;
import fr.enedis.chutney.execution.infra.execution.ExecutionRequestMapper;
import fr.enedis.chutney.execution.infra.execution.ServerTestEngineJavaImpl;
import fr.enedis.chutney.index.infra.LuceneIndexRepository;
import fr.enedis.chutney.index.infra.config.IndexConfig;
import fr.enedis.chutney.index.infra.config.OnDiskIndexConfig;
import fr.enedis.chutney.jira.api.JiraXrayEmbeddedApi;
import fr.enedis.chutney.migration.domain.DataMigrationExecutor;
import fr.enedis.chutney.migration.domain.DataMigrator;
import fr.enedis.chutney.scenario.infra.TestCaseRepositoryAggregator;
import fr.enedis.chutney.security.domain.AuthenticationService;
import fr.enedis.chutney.security.domain.Authorizations;
import fr.enedis.chutney.server.core.domain.execution.ScenarioExecutionEngine;
import fr.enedis.chutney.server.core.domain.execution.ScenarioExecutionEngineAsync;
import fr.enedis.chutney.server.core.domain.execution.ServerTestEngine;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import fr.enedis.chutney.server.core.domain.execution.state.ExecutionStateRepository;
import fr.enedis.chutney.server.core.domain.instrument.ChutneyMetrics;
import jakarta.annotation.PostConstruct;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootApplication(exclude={LiquibaseAutoConfiguration.class, ActiveMQAutoConfiguration.class, MongoAutoConfiguration.class})
@EnableAspectJAutoProxy
public class ServerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfiguration.class);
    @Value(value="${server.port}")
    int port;

    @PostConstruct
    public void logPort() throws UnknownHostException {
        LOGGER.debug("Starting server {} on {}", (Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)this.port);
    }

    @Bean
    public ThreadPoolTaskExecutor engineExecutor(@Value(value="${chutney.engine.executor.pool-size:20}") Integer threadForEngine) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadForEngine.intValue());
        executor.setMaxPoolSize(threadForEngine.intValue());
        executor.setThreadNamePrefix("engine-executor");
        executor.initialize();
        LOGGER.debug("Pool for engine created with size {}", (Object)threadForEngine);
        return executor;
    }

    @Bean
    public TaskExecutor campaignExecutor(@Value(value="${chutney.server.campaigns.executor.pool-size:20}") Integer threadForCampaigns) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadForCampaigns.intValue());
        executor.setMaxPoolSize(threadForCampaigns.intValue());
        executor.setThreadNamePrefix("campaign-executor");
        executor.initialize();
        LOGGER.debug("Pool for campaigns created with size {}", (Object)threadForCampaigns);
        return executor;
    }

    @Bean
    public ExecutionConfiguration executionConfiguration(@Value(value="${chutney.engine.reporter.publisher.ttl:5}") Long reporterTTL, @Qualifier(value="engineExecutor") ThreadPoolTaskExecutor engineExecutor, @Value(value="${chutney.actions.sql.max-logged-rows:30}") String nbLoggedRow, @Value(value="${chutney.engine.delegation.user:#{null}}") String delegateUser, @Value(value="${chutney.engine.delegation.password:#{null}}") String delegatePassword) {
        HashMap<String, String> actionsConfiguration = new HashMap<String, String>();
        actionsConfiguration.put("chutney.actions.sql.max-logged-rows", nbLoggedRow);
        return new ExecutionConfiguration(reporterTTL, (ExecutorService)engineExecutor.getThreadPoolExecutor(), actionsConfiguration, delegateUser, delegatePassword);
    }

    @Bean
    public SpringLiquibase liquibase(DataSource dataSource) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setChangeLog("classpath:changelog/db.changelog-master.xml");
        liquibase.setContexts("!test");
        liquibase.setDataSource(dataSource);
        return liquibase;
    }

    @Bean
    ScenarioExecutionEngine scenarioExecutionEngine(ServerTestEngine executionEngine, ScenarioExecutionEngineAsync executionEngineAsync) {
        return new ScenarioExecutionEngine(executionEngine, executionEngineAsync);
    }

    @Bean
    ScenarioExecutionEngineAsync scenarioExecutionEngineAsync(ExecutionHistoryRepository executionHistoryRepository, ServerTestEngine executionEngine, ExecutionStateRepository executionStateRepository, ChutneyMetrics metrics, @Qualifier(value="reportObjectMapper") ObjectMapper objectMapper, @Value(value="${chutney.server.execution.async.publisher.ttl:5}") long replayerRetention, @Value(value="${chutney.server.execution.async.publisher.debounce:250}") long debounceMilliSeconds) {
        return new ScenarioExecutionEngineAsync(executionHistoryRepository, executionEngine, executionStateRepository, metrics, objectMapper, replayerRetention, debounceMilliSeconds);
    }

    @Bean
    CampaignExecutionEngine campaignExecutionEngine(CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, ScenarioExecutionEngine scenarioExecutionEngine, ScenarioExecutionEngineAsync scenarioExecutionEngineAsync, ExecutionHistoryRepository executionHistoryRepository, TestCaseRepositoryAggregator testCaseRepository, JiraXrayEmbeddedApi jiraXrayEmbeddedApi, ChutneyMetrics metrics, @Qualifier(value="campaignExecutor") TaskExecutor campaignExecutor, DataSetRepository datasetRepository, ObjectMapper objectMapper) {
        return new CampaignExecutionEngine(campaignRepository, campaignExecutionRepository, scenarioExecutionEngine, scenarioExecutionEngineAsync, executionHistoryRepository, testCaseRepository, jiraXrayEmbeddedApi, metrics, (ExecutorService)new ExecutorServiceAdapter(campaignExecutor), datasetRepository, objectMapper);
    }

    @Bean
    TestCaseEditionsService testCaseEditionsService(TestCaseEditions testCaseEditions, TestCaseRepositoryAggregator testCaseRepository) {
        return new TestCaseEditionsService(testCaseEditions, testCaseRepository);
    }

    @Bean
    TestEngine embeddedTestEngine(ExecutionConfiguration executionConfiguration) {
        return executionConfiguration.embeddedTestEngine();
    }

    @Bean
    ServerTestEngine javaTestEngine(TestEngine embeddedTestEngine, ExecutionRequestMapper executionRequestMapper) {
        return new ServerTestEngineJavaImpl(embeddedTestEngine, executionRequestMapper);
    }

    @Bean
    EmbeddedActionEngine embeddedActionEngine(ExecutionConfiguration executionConfiguration) {
        return new EmbeddedActionEngine(executionConfiguration.actionTemplateRegistry());
    }

    @Bean
    Clock clock() {
        return Clock.systemDefaultZone();
    }

    @Bean
    CampaignService campaignService(CampaignExecutionRepository campaignExecutionRepository) {
        return new CampaignService(campaignExecutionRepository);
    }

    @Bean
    CampaignEnvironmentUpdateHandler campaignEnvironmentUpdateHandler(CampaignRepository campaignRepository) {
        return new CampaignEnvironmentUpdateHandler(campaignRepository);
    }

    @Bean
    public AuthenticationService authenticationService(Authorizations authorizations) {
        return new AuthenticationService(authorizations);
    }

    @Bean
    public ObjectMapper reportObjectMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).findAndRegisterModules();
    }

    @Bean
    public DataMigrationExecutor dataMigrationExecutor(@Value(value="${chutney.server.indexes.build.time.ttl.value:6}") long indexingTtlValue, @Value(value="${chutney.server.indexes.build.time.ttl.unit:HOURS}") String indexingTtlUnit, List<DataMigrator> dataMigrators) {
        return new DataMigrationExecutor(indexingTtlValue, indexingTtlUnit, dataMigrators);
    }

    @Bean
    public LuceneIndexRepository reportLuceneIndexRepository(IndexConfig reportIndexConfig) {
        return new LuceneIndexRepository(reportIndexConfig);
    }

    @Bean
    public LuceneIndexRepository scenarioLuceneIndexRepository(IndexConfig scenarioIndexConfig) {
        return new LuceneIndexRepository(scenarioIndexConfig);
    }

    @Bean
    public LuceneIndexRepository datasetLuceneIndexRepository(IndexConfig datasetIndexConfig) {
        return new LuceneIndexRepository(datasetIndexConfig);
    }

    @Bean
    public LuceneIndexRepository campaignLuceneIndexRepository(IndexConfig campaignIndexConfig) {
        return new LuceneIndexRepository(campaignIndexConfig);
    }

    @Bean
    public IndexConfig reportIndexConfig(@Value(value="${chutney.index-folder:~/.chutney/index}") String directory) {
        return new OnDiskIndexConfig(directory, "report");
    }

    @Bean
    public IndexConfig scenarioIndexConfig(@Value(value="${chutney.index-folder:~/.chutney/index}") String directory) {
        return new OnDiskIndexConfig(directory, "scenario");
    }

    @Bean
    public IndexConfig datasetIndexConfig(@Value(value="${chutney.index-folder:~/.chutney/index}") String directory) {
        return new OnDiskIndexConfig(directory, "dataset");
    }

    @Bean
    public IndexConfig campaignIndexConfig(@Value(value="${chutney.index-folder:~/.chutney/index}") String directory) {
        return new OnDiskIndexConfig(directory, "campaign");
    }
}

