/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import fr.enedis.chutney.security.AuditHandler;
import fr.enedis.chutney.tools.MyMixInForIgnoreType;
import java.io.File;
import java.nio.file.Paths;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfiguration
implements WebMvcConfigurer {
    @Bean
    @Primary
    public ObjectMapper webObjectMapper() {
        return new ObjectMapper().addMixIn(Resource.class, MyMixInForIgnoreType.class).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).findAndRegisterModules();
    }

    @Bean
    WebServerFactoryCustomizer<AbstractServletWebServerFactory> embeddedServletContainerCustomizer() {
        return this::setLocationForStaticAssets;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuditHandler());
    }

    private void setLocationForStaticAssets(AbstractServletWebServerFactory container) {
        File root = new File(this.resolvePathPrefix() + "ui/dist/chutney/");
        if (root.exists() && root.isDirectory()) {
            container.setDocumentRoot(root);
        }
    }

    private String resolvePathPrefix() {
        String rootPath;
        String fullExecutablePath = this.getClass().getResource("").getPath();
        String extractedPath = fullExecutablePath.replace(rootPath = Paths.get(".", new String[0]).toUri().normalize().getPath(), "");
        int extractionEndIndex = extractedPath.indexOf("target/");
        if (extractionEndIndex < 0) {
            return "";
        }
        if (extractionEndIndex == 0) {
            return "../";
        }
        return rootPath;
    }
}

