/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import fr.enedis.chutney.agent.domain.AgentClient;
import fr.enedis.chutney.agent.domain.configure.ConfigureService;
import fr.enedis.chutney.agent.domain.configure.Explorations;
import fr.enedis.chutney.agent.domain.configure.GetCurrentNetworkDescriptionService;
import fr.enedis.chutney.agent.domain.configure.LocalServerIdentifier;
import fr.enedis.chutney.agent.domain.explore.CurrentNetworkDescription;
import fr.enedis.chutney.agent.domain.explore.ExploreAgentsService;
import fr.enedis.chutney.agent.infra.storage.JsonFileAgentNetworkDao;
import fr.enedis.chutney.engine.domain.delegation.ConnectionChecker;
import fr.enedis.chutney.environment.api.environment.EmbeddedEnvironmentApi;
import fr.enedis.chutney.environment.api.environment.EnvironmentApi;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class NodeNetworkSpringConfiguration {
    private static final String NODE_NETWORK_QUALIFIER = "agentnetwork";

    @Bean
    public ObjectMapper agentNetworkObjectMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).findAndRegisterModules();
    }

    @Bean
    LocalServerIdentifier localServerIdentifier(@Value(value="${server.port}") int port, @Value(value="${chutney.server.agent.name:#{null}}") Optional<String> defaultLocalName, @Value(value="${chutney.server.agent.hostname:#{null}}") Optional<String> defaultLocalHostName) throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        return new LocalServerIdentifier(port, defaultLocalName.orElse(localHost.getHostName()), defaultLocalHostName.orElse(localHost.getCanonicalHostName()));
    }

    @Bean
    @Qualifier(value="agentnetwork")
    public RestTemplate restTemplateForHttpNodeNetwork(@Qualifier(value="agentNetworkObjectMapper") ObjectMapper nodeNetworkObjectMapper) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setMessageConverters((List)Lists.newArrayList((Object[])new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter(nodeNetworkObjectMapper)}));
        return restTemplate;
    }

    @Bean
    ExploreAgentsService agentNetwork(Explorations explorations, AgentClient agentClient, ConnectionChecker connectionChecker, LocalServerIdentifier localServerIdentifier) {
        return new ExploreAgentsService(explorations, agentClient, connectionChecker, localServerIdentifier);
    }

    @Bean
    ConfigureService configureService(ExploreAgentsService exploreAgentsService, CurrentNetworkDescription currentNetworkDescription, LocalServerIdentifier localServerIdentifier, EmbeddedEnvironmentApi environmentApi) {
        return new ConfigureService(exploreAgentsService, currentNetworkDescription, localServerIdentifier, (EnvironmentApi)environmentApi);
    }

    @Bean
    GetCurrentNetworkDescriptionService getCurrentNetworkDescriptionService(CurrentNetworkDescription currentNetworkDescription) {
        return new GetCurrentNetworkDescriptionService(currentNetworkDescription);
    }

    @Bean
    JsonFileAgentNetworkDao getJsonFileAgentNetworkDao(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String storeFolderPath) {
        return new JsonFileAgentNetworkDao(storeFolderPath);
    }
}

