/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.api;

import fr.enedis.chutney.agent.api.dto.ExploreResultApiDto;
import fr.enedis.chutney.agent.api.dto.NetworkConfigurationApiDto;
import fr.enedis.chutney.agent.api.dto.NetworkDescriptionApiDto;
import fr.enedis.chutney.agent.api.mapper.ExploreResultApiMapper;
import fr.enedis.chutney.agent.api.mapper.NetworkConfigurationApiMapper;
import fr.enedis.chutney.agent.api.mapper.NetworkDescriptionApiMapper;
import fr.enedis.chutney.agent.domain.configure.ConfigureService;
import fr.enedis.chutney.agent.domain.configure.GetCurrentNetworkDescriptionService;
import fr.enedis.chutney.agent.domain.configure.NetworkConfiguration;
import fr.enedis.chutney.agent.domain.explore.ExploreAgentsService;
import fr.enedis.chutney.agent.domain.explore.ExploreResult;
import fr.enedis.chutney.agent.domain.network.NetworkDescription;
import fr.enedis.chutney.environment.api.environment.EmbeddedEnvironmentApi;
import fr.enedis.chutney.environment.api.environment.EnvironmentApi;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NodeNetworkController {
    private final ConfigureService configureService;
    private final GetCurrentNetworkDescriptionService getCurrentNetworkDescription;
    private final ExploreAgentsService exploreAgentsService;
    private final EnvironmentApi embeddedEnvironmentApi;
    private final NetworkConfigurationApiMapper networkConfigurationApiMapper;
    private final NetworkDescriptionApiMapper networkDescriptionApiMapper;
    private final ExploreResultApiMapper exploreResultApiMapper;
    public static final String CONFIGURE_URL = "/api/v1/agentnetwork/configuration";
    public static final String DESCRIPTION_URL = "/api/v1/description";
    public static final String EXPLORE_URL = "/api/v1/agentnetwork/explore";
    public static final String WRAP_UP_URL = "/api/v1/agentnetwork/wrapup";

    public NodeNetworkController(ConfigureService configureService, GetCurrentNetworkDescriptionService getCurrentNetworkDescription, ExploreAgentsService exploreAgentsService, EmbeddedEnvironmentApi embeddedEnvironmentApi, NetworkDescriptionApiMapper networkDescriptionApiMapper, ExploreResultApiMapper exploreResultApiMapper, NetworkConfigurationApiMapper networkConfigurationApiMapper) {
        this.configureService = configureService;
        this.getCurrentNetworkDescription = getCurrentNetworkDescription;
        this.exploreAgentsService = exploreAgentsService;
        this.embeddedEnvironmentApi = embeddedEnvironmentApi;
        this.networkDescriptionApiMapper = networkDescriptionApiMapper;
        this.exploreResultApiMapper = exploreResultApiMapper;
        this.networkConfigurationApiMapper = networkConfigurationApiMapper;
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(value={"/api/v1/agentnetwork/configuration"})
    public NetworkDescriptionApiDto configure(@RequestBody NetworkConfigurationApiDto networkConfigurationApi) {
        NetworkConfiguration networkConfiguration = this.networkConfigurationApiMapper.fromDtoAtNow(networkConfigurationApi);
        NetworkConfiguration enhancedWithEnvironmentNetworkConfiguration = this.networkConfigurationApiMapper.enhanceWithEnvironment(networkConfiguration, this.embeddedEnvironmentApi.listEnvironments());
        NetworkDescription networkDescription = this.configureService.configure(enhancedWithEnvironmentNetworkConfiguration);
        return this.networkDescriptionApiMapper.toDto(networkDescription);
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(value={"/api/v1/description"})
    public NetworkDescriptionApiDto getConfiguration() {
        return this.networkDescriptionApiMapper.toDto(this.getCurrentNetworkDescription.getCurrentNetworkDescription());
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(value={"/api/v1/agentnetwork/explore"})
    public ExploreResultApiDto explore(@RequestBody NetworkConfigurationApiDto networkConfigurationApiDto) {
        NetworkConfiguration networkConfiguration = this.networkConfigurationApiMapper.fromDto(networkConfigurationApiDto);
        ExploreResult links = this.exploreAgentsService.explore(networkConfiguration);
        return this.exploreResultApiMapper.from(links);
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(value={"/api/v1/agentnetwork/wrapup"})
    public void wrapUp(@RequestBody NetworkDescriptionApiDto networkDescriptionApiDto) {
        NetworkDescription networkDescription = this.networkDescriptionApiMapper.fromDto(networkDescriptionApiDto);
        this.configureService.wrapUpConfiguration(networkDescription);
    }
}

