/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.infra;

import fr.enedis.chutney.agent.domain.configure.ConfigurationState;
import fr.enedis.chutney.agent.domain.configure.Explorations;
import fr.enedis.chutney.agent.domain.configure.NetworkConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class InMemoryExplorations
implements Explorations {
    private final Map<NetworkConfiguration, ConfigurationState> networkConfigurationsState = new ConcurrentHashMap<NetworkConfiguration, ConfigurationState>();

    @Override
    public boolean changeStateToIfPossible(NetworkConfiguration networkConfiguration, ConfigurationState newState) {
        ConfigurationState currentState = this.networkConfigurationsState.getOrDefault(networkConfiguration, ConfigurationState.NOT_STARTED);
        if (currentState.canChangeTo(newState)) {
            this.networkConfigurationsState.put(networkConfiguration, newState);
            return true;
        }
        return false;
    }

    @Override
    public void remove(NetworkConfiguration networkConfiguration) {
        this.networkConfigurationsState.remove(networkConfiguration);
    }
}

