/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.infra.storage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.io.Files;
import fr.enedis.chutney.agent.infra.storage.AgentNetworkForJsonFile;
import fr.enedis.chutney.server.core.domain.tools.ZipUtils;
import fr.enedis.chutney.tools.ThrowingSupplier;
import fr.enedis.chutney.tools.file.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipOutputStream;

public class JsonFileAgentNetworkDao {
    static final Path ROOT_DIRECTORY_NAME = Paths.get("agents", new String[0]);
    static final String AGENTS_FILE_NAME = "endpoints.json";
    private final ObjectMapper objectMapper;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(false);
    private final File file;

    public JsonFileAgentNetworkDao(String storeFolderPath) {
        this(storeFolderPath, JsonFileAgentNetworkDao.buildObjectMapper());
    }

    JsonFileAgentNetworkDao(String storeFolderPath, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        Path dir = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME).toAbsolutePath();
        FileUtils.initFolder((Path)dir);
        this.file = dir.resolve(AGENTS_FILE_NAME).toFile();
        this.file.delete();
    }

    public Optional<AgentNetworkForJsonFile> read() {
        return (Optional)this.executeWithLocking(this.rwLock.readLock(), () -> {
            if (!this.file.exists()) {
                return Optional.empty();
            }
            return Optional.of((AgentNetworkForJsonFile)this.objectMapper.readValue(this.file, AgentNetworkForJsonFile.class));
        });
    }

    public void save(AgentNetworkForJsonFile agentEndpointsConfiguration) {
        this.executeWithLocking(this.rwLock.writeLock(), () -> {
            Files.createParentDirs((File)this.file);
            this.objectMapper.writeValue(this.file, (Object)agentEndpointsConfiguration);
        });
    }

    public void backup(OutputStream outputStream) {
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            ZipUtils.compressFile((File)this.file, (String)this.file.getName(), (ZipOutputStream)zipOutPut);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithLocking(Lock lock, ThrowingSupplier<T, ? extends Exception> supplier) {
        lock.lock();
        try {
            Object object = supplier.unsafeGet();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT);
        return objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }
}

