/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import fr.enedis.chutney.campaign.api.dto.CampaignExecutionReportDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CampaignDto {
    private Long id;
    private String title;
    private String description;
    private List<CampaignScenarioDto> scenarios;
    private List<CampaignExecutionReportDto> campaignExecutionReports;
    private String environment;
    private boolean parallelRun;
    private boolean retryAuto;
    private String datasetId;
    private List<String> tags;

    public CampaignDto() {
    }

    public CampaignDto(Long id, String title, String description, List<CampaignScenarioDto> scenarios, List<CampaignExecutionReportDto> campaignExecutionReports, String environment, boolean parallelRun, boolean retryAuto, String datasetId, List<String> tags) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.scenarios = Optional.ofNullable(scenarios).orElseGet(ArrayList::new);
        this.campaignExecutionReports = Optional.ofNullable(campaignExecutionReports).orElseGet(ArrayList::new);
        this.environment = environment;
        this.parallelRun = parallelRun;
        this.retryAuto = retryAuto;
        this.datasetId = datasetId;
        this.tags = Optional.ofNullable(tags).orElseGet(ArrayList::new);
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CampaignScenarioDto> getScenarios() {
        return this.scenarios;
    }

    public List<CampaignExecutionReportDto> getCampaignExecutionReports() {
        return this.campaignExecutionReports;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isParallelRun() {
        return this.parallelRun;
    }

    public boolean isRetryAuto() {
        return this.retryAuto;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public record CampaignScenarioDto(String scenarioId, String datasetId) {
        public CampaignScenarioDto(String scenarioId) {
            this(scenarioId, null);
        }
    }
}

