/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.api.dto;

import fr.enedis.chutney.campaign.api.dto.CampaignDto;
import fr.enedis.chutney.campaign.api.dto.CampaignExecutionReportDto;
import fr.enedis.chutney.campaign.api.dto.CampaignExecutionReportMapper;
import fr.enedis.chutney.server.core.domain.scenario.campaign.Campaign;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CampaignMapper {
    public static CampaignDto toDtoWithoutReport(Campaign campaign) {
        return new CampaignDto(campaign.id, campaign.title, campaign.description, campaign.scenarios.stream().map(CampaignMapper::toDto).toList(), Collections.emptyList(), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.executionDataset(), campaign.tags);
    }

    public static CampaignDto toDto(Campaign campaign, List<CampaignExecution> campaignExecutions) {
        return new CampaignDto(campaign.id, campaign.title, campaign.description, campaign.scenarios.stream().map(CampaignMapper::toDto).toList(), CampaignMapper.reportToDto(campaignExecutions), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.executionDataset(), campaign.tags);
    }

    public static Campaign fromDto(CampaignDto dto) {
        return new Campaign(dto.getId(), dto.getTitle(), dto.getDescription(), CampaignMapper.campaignScenariosFromDto(dto), dto.getEnvironment(), dto.isParallelRun(), dto.isRetryAuto(), !StringUtils.isBlank((CharSequence)dto.getDatasetId()) ? dto.getDatasetId() : null, dto.getTags().stream().map(String::trim).map(String::toUpperCase).collect(Collectors.toList()));
    }

    public static CampaignDto.CampaignScenarioDto toDto(Campaign.CampaignScenario campaignScenario) {
        return new CampaignDto.CampaignScenarioDto(campaignScenario.scenarioId(), campaignScenario.datasetId());
    }

    public static Campaign.CampaignScenario fromDto(CampaignDto.CampaignScenarioDto dto) {
        return new Campaign.CampaignScenario(dto.scenarioId(), dto.datasetId());
    }

    private static List<CampaignExecutionReportDto> reportToDto(List<CampaignExecution> campaignExecutions) {
        return campaignExecutions != null ? campaignExecutions.stream().map(CampaignExecutionReportMapper::toDto).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static List<Campaign.CampaignScenario> campaignScenariosFromDto(CampaignDto dto) {
        return Optional.ofNullable(dto.getScenarios()).filter(Predicate.not(List::isEmpty)).map(list -> list.stream().map(sc -> new Campaign.CampaignScenario(sc.scenarioId(), sc.datasetId())).toList()).orElse(Collections.emptyList());
    }
}

