/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.domain;

import fr.enedis.chutney.campaign.domain.CampaignRepository;
import fr.enedis.chutney.server.core.domain.environment.UpdateEnvironmentHandler;
import fr.enedis.chutney.server.core.domain.scenario.campaign.Campaign;

public class CampaignEnvironmentUpdateHandler
implements UpdateEnvironmentHandler {
    private final CampaignRepository campaignRepository;

    public CampaignEnvironmentUpdateHandler(CampaignRepository campaignRepository) {
        this.campaignRepository = campaignRepository;
    }

    public void renameEnvironment(String oldName, String newName) {
        this.campaignRepository.findCampaignsByEnvironment(oldName).forEach(existingCampaign -> {
            Campaign campaign = new Campaign(existingCampaign.id, existingCampaign.title, existingCampaign.description, existingCampaign.scenarios, newName, existingCampaign.parallelRun, existingCampaign.retryAuto, existingCampaign.executionDataset(), existingCampaign.tags);
            this.campaignRepository.createOrUpdate(campaign);
        });
    }

    public void deleteEnvironment(String environmentName) {
        this.campaignRepository.findCampaignsByEnvironment(environmentName).forEach(existingCampaign -> {
            Campaign campaign = new Campaign(existingCampaign.id, existingCampaign.title, existingCampaign.description, existingCampaign.scenarios, null, existingCampaign.parallelRun, existingCampaign.retryAuto, existingCampaign.executionDataset(), existingCampaign.tags);
            this.campaignRepository.createOrUpdate(campaign);
        });
    }
}

