/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.domain;

import fr.enedis.chutney.campaign.domain.Frequency;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class PeriodicScheduledCampaign {
    public final Long id;
    public final LocalDateTime nextExecutionDate;
    public final Frequency frequency;
    public final String environment;
    public final List<CampaignExecutionRequest> campaignExecutionRequests;

    public PeriodicScheduledCampaign(Long id, LocalDateTime nextExecutionDate, Frequency frequency, String environment, List<CampaignExecutionRequest> campaignExecutionRequests) {
        this.id = id;
        this.nextExecutionDate = nextExecutionDate;
        this.frequency = frequency;
        this.environment = environment;
        this.campaignExecutionRequests = campaignExecutionRequests;
    }

    public PeriodicScheduledCampaign nextScheduledExecution() {
        LocalDateTime scheduledDate = switch (this.frequency) {
            case Frequency.HOURLY -> this.nextExecutionDate.plusHours(1L);
            case Frequency.DAILY -> this.nextExecutionDate.plusDays(1L);
            case Frequency.WEEKLY -> this.nextExecutionDate.plusWeeks(1L);
            case Frequency.MONTHLY -> this.nextExecutionDate.plusMonths(1L);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.frequency));
        };
        return new PeriodicScheduledCampaign(this.id, scheduledDate, this.frequency, this.environment, this.campaignExecutionRequests);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodicScheduledCampaign that = (PeriodicScheduledCampaign)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.nextExecutionDate, that.nextExecutionDate) && Objects.equals((Object)this.frequency, (Object)that.frequency) && Objects.equals(this.environment, that.environment) && Objects.equals(this.campaignExecutionRequests, that.campaignExecutionRequests);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.nextExecutionDate, this.frequency, this.environment, this.campaignExecutionRequests});
    }

    public String toString() {
        return "SchedulingCampaign{id=" + this.id + ", schedulingDate=" + String.valueOf(this.nextExecutionDate) + ", frequency='" + String.valueOf((Object)this.frequency) + "', environment='" + this.environment + "', campaignExecutionRequests='" + String.valueOf(this.campaignExecutionRequests) + "'}";
    }

    public record CampaignExecutionRequest(Long campaignId, String campaignTitle, String datasetId) {
    }
}

