/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

@JsonPropertyOrder(value={"id", "schedulingDate", "environment", "campaignsId", "campaignsTitle", "datasetsId"})
public class SchedulingCampaignDto {
    public final String id;
    public final LocalDateTime schedulingDate;
    public final String frequency;
    public final String environment;
    @JsonIgnore
    public final List<CampaignExecutionRequestDto> campaignExecutionRequestDto;

    @JsonCreator
    public SchedulingCampaignDto() {
        this.id = null;
        this.schedulingDate = null;
        this.frequency = null;
        this.environment = null;
        this.campaignExecutionRequestDto = null;
    }

    @JsonIgnore
    public SchedulingCampaignDto(String id, LocalDateTime schedulingDate, String frequency, String environment, List<CampaignExecutionRequestDto> campaignExecutionRequestDto) {
        this.id = id;
        this.schedulingDate = schedulingDate;
        this.frequency = frequency;
        this.campaignExecutionRequestDto = campaignExecutionRequestDto;
        this.environment = environment;
    }

    public List<Long> getCampaignsId() {
        return this.campaignExecutionRequestDto != null ? this.campaignExecutionRequestDto.stream().map(cer -> cer.campaignId).toList() : Collections.emptyList();
    }

    public List<String> getCampaignsTitle() {
        return this.campaignExecutionRequestDto != null ? this.campaignExecutionRequestDto.stream().map(cer -> cer.campaignTitle).toList() : Collections.emptyList();
    }

    public List<String> getDatasetsId() {
        return this.campaignExecutionRequestDto != null ? this.campaignExecutionRequestDto.stream().map(cer -> cer.datasetId).toList() : Collections.emptyList();
    }

    public record CampaignExecutionRequestDto(Long campaignId, String campaignTitle, String datasetId) {
    }
}

