/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.enedis.chutney.campaign.domain.Frequency;
import fr.enedis.chutney.campaign.domain.PeriodicScheduledCampaign;
import fr.enedis.chutney.campaign.domain.ScheduledCampaignRepository;
import fr.enedis.chutney.campaign.infra.SchedulingCampaignDto;
import fr.enedis.chutney.campaign.infra.SchedulingCampaignsDtoDeserializer;
import fr.enedis.chutney.tools.file.FileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class SchedulingCampaignFileRepository
implements ScheduledCampaignRepository {
    private static final Path ROOT_DIRECTORY_NAME = Paths.get("scheduling", new String[0]);
    private static final String SCHEDULING_CAMPAIGNS_FILE = "schedulingCampaigns.json";
    private final Path storeFolderPath;
    private final Path resolvedFilePath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().registerModule((Module)new JavaTimeModule()).registerModule((Module)new SimpleModule().addDeserializer(SchedulingCampaignDto.class, (JsonDeserializer)new SchedulingCampaignsDtoDeserializer())).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    SchedulingCampaignFileRepository(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        this.resolvedFilePath = this.storeFolderPath.resolve(SCHEDULING_CAMPAIGNS_FILE);
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodicScheduledCampaign add(PeriodicScheduledCampaign periodicScheduledCampaign) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            Map<String, SchedulingCampaignDto> schedulingCampaigns = this.readFromDisk();
            Long nextId = this.getCurrentMaxId(schedulingCampaigns) + 1L;
            schedulingCampaigns.put(String.valueOf(nextId), this.toDto(nextId, periodicScheduledCampaign));
            this.writeOnDisk(this.resolvedFilePath, schedulingCampaigns);
            PeriodicScheduledCampaign periodicScheduledCampaign2 = periodicScheduledCampaign;
            return periodicScheduledCampaign2;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeById(Long id) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            Map<String, SchedulingCampaignDto> schedulingCampaigns = this.readFromDisk();
            schedulingCampaigns.remove(String.valueOf(id));
            this.writeOnDisk(this.resolvedFilePath, schedulingCampaigns);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCampaignId(Long id) {
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            Map<String, SchedulingCampaignDto> schedulingCampaigns = this.readFromDisk();
            HashMap<String, SchedulingCampaignDto> schedulingCampaignsFiltered = new HashMap<String, SchedulingCampaignDto>();
            schedulingCampaigns.forEach((key, schedulingCampaignDto) -> {
                Optional<SchedulingCampaignDto.CampaignExecutionRequestDto> foundRequest = schedulingCampaignDto.campaignExecutionRequestDto.stream().filter(cer -> cer.campaignId().equals(id)).findFirst();
                foundRequest.ifPresent(schedulingCampaignDto.campaignExecutionRequestDto::remove);
                if (!schedulingCampaignDto.campaignExecutionRequestDto.isEmpty()) {
                    schedulingCampaignsFiltered.put((String)key, (SchedulingCampaignDto)schedulingCampaignDto);
                }
            });
            this.writeOnDisk(this.resolvedFilePath, schedulingCampaignsFiltered);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public List<PeriodicScheduledCampaign> getAll() {
        return this.readFromDisk().values().stream().map(this::fromDto).collect(Collectors.toList());
    }

    private Map<String, SchedulingCampaignDto> readFromDisk() {
        HashMap<String, SchedulingCampaignDto> stringSchedulingCampaignDTO = new HashMap<String, SchedulingCampaignDto>();
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            if (Files.exists(this.resolvedFilePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(this.resolvedFilePath);
                stringSchedulingCampaignDTO.putAll((Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<HashMap<String, SchedulingCampaignDto>>(this){}));
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + String.valueOf(this.resolvedFilePath), e);
        }
        finally {
            readLock.unlock();
        }
        return stringSchedulingCampaignDTO;
    }

    private void writeOnDisk(Path filePath, Map<String, SchedulingCampaignDto> schedulingCampaignDTO) {
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(schedulingCampaignDTO);
            try {
                Files.write(filePath, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write in configuration directory: " + String.valueOf(this.storeFolderPath), e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + String.valueOf(schedulingCampaignDTO), e);
        }
    }

    private PeriodicScheduledCampaign fromDto(SchedulingCampaignDto dto) {
        return new PeriodicScheduledCampaign(Long.valueOf(dto.id), dto.schedulingDate, Frequency.toFrequency(dto.frequency), dto.environment, dto.campaignExecutionRequestDto.stream().map(aa -> new PeriodicScheduledCampaign.CampaignExecutionRequest(aa.campaignId(), aa.campaignTitle(), aa.datasetId())).toList());
    }

    private SchedulingCampaignDto toDto(long id, PeriodicScheduledCampaign periodicScheduledCampaign) {
        return new SchedulingCampaignDto(String.valueOf(id), periodicScheduledCampaign.nextExecutionDate, periodicScheduledCampaign.frequency.label, periodicScheduledCampaign.environment, periodicScheduledCampaign.campaignExecutionRequests.stream().map(aa -> new SchedulingCampaignDto.CampaignExecutionRequestDto(aa.campaignId(), aa.campaignTitle(), aa.datasetId())).toList());
    }

    private Long getCurrentMaxId(Map<String, SchedulingCampaignDto> schedulingCampaigns) {
        return schedulingCampaigns.keySet().stream().mapToLong(Long::valueOf).max().orElse(0L);
    }
}

