/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra.jpa;

import fr.enedis.chutney.campaign.infra.jpa.CampaignEntity;
import fr.enedis.chutney.server.core.domain.scenario.campaign.Campaign;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.List;
import java.util.stream.IntStream;

@Entity(name="CAMPAIGN_SCENARIOS")
public class CampaignScenarioEntity {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CAMPAIGN_ID")
    private CampaignEntity campaign;
    @Column(name="SCENARIO_ID")
    private String scenarioId;
    @Column(name="DATASET_ID")
    private String datasetId;
    @Column(name="RANK")
    private Integer rank;

    public CampaignScenarioEntity() {
    }

    private CampaignScenarioEntity(String scenarioId, String datasetId, Integer rank) {
        this(null, scenarioId, datasetId, rank);
    }

    public CampaignScenarioEntity(CampaignEntity campaign, String scenarioId, String datasetId, Integer rank) {
        this.campaign = campaign;
        this.scenarioId = scenarioId;
        this.datasetId = datasetId;
        this.rank = rank;
    }

    public String scenarioId() {
        return this.scenarioId;
    }

    public CampaignEntity campaign() {
        return this.campaign;
    }

    public String datasetId() {
        return this.datasetId;
    }

    public void forCampaign(CampaignEntity campaign) {
        this.campaign = campaign;
    }

    public static List<CampaignScenarioEntity> fromDomain(Campaign campaign) {
        return IntStream.range(0, campaign.scenarios.size()).mapToObj(idx -> new CampaignScenarioEntity(((Campaign.CampaignScenario)campaign.scenarios.get(idx)).scenarioId(), ((Campaign.CampaignScenario)campaign.scenarios.get(idx)).datasetId(), idx)).toList();
    }
}

