/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.dataset.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import fr.enedis.chutney.dataset.api.DataSetDto;
import fr.enedis.chutney.dataset.api.KeyValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DataSetDto", generator="Immutables")
@Immutable
public final class ImmutableDataSetDto
implements DataSetDto {
    @Nullable
    private final String id;
    private final String name;
    private final String description;
    private final Instant lastUpdated;
    private final List<String> tags;
    private final List<KeyValue> constants;
    private final List<List<KeyValue>> datatable;
    private final List<String> scenarioUsage;
    private final List<String> campaignUsage;
    private final Map<String, Set<String>> scenarioInCampaignUsage;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDataSetDto(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        if (builder.description != null) {
            this.initShim.description(builder.description);
        }
        if (builder.lastUpdated != null) {
            this.initShim.lastUpdated(builder.lastUpdated);
        }
        if (builder.tagsIsSet()) {
            this.initShim.tags(ImmutableDataSetDto.createUnmodifiableList(true, builder.tags));
        }
        if (builder.constantsIsSet()) {
            this.initShim.constants(ImmutableDataSetDto.createUnmodifiableList(true, builder.constants));
        }
        if (builder.datatableIsSet()) {
            this.initShim.datatable(ImmutableDataSetDto.createUnmodifiableList(true, builder.datatable));
        }
        if (builder.scenarioUsageIsSet()) {
            this.initShim.scenarioUsage(ImmutableDataSetDto.createUnmodifiableList(true, builder.scenarioUsage));
        }
        if (builder.campaignUsageIsSet()) {
            this.initShim.campaignUsage(ImmutableDataSetDto.createUnmodifiableList(true, builder.campaignUsage));
        }
        if (builder.scenarioInCampaignUsageIsSet()) {
            this.initShim.scenarioInCampaignUsage(ImmutableDataSetDto.createUnmodifiableMap(false, false, builder.scenarioInCampaignUsage));
        }
        this.description = this.initShim.description();
        this.lastUpdated = this.initShim.lastUpdated();
        this.tags = this.initShim.tags();
        this.constants = this.initShim.constants();
        this.datatable = this.initShim.datatable();
        this.scenarioUsage = this.initShim.scenarioUsage();
        this.campaignUsage = this.initShim.campaignUsage();
        this.scenarioInCampaignUsage = this.initShim.scenarioInCampaignUsage();
        this.initShim = null;
    }

    private ImmutableDataSetDto(@Nullable String id, String name, String description, Instant lastUpdated, List<String> tags, List<KeyValue> constants, List<List<KeyValue>> datatable, List<String> scenarioUsage, List<String> campaignUsage, Map<String, Set<String>> scenarioInCampaignUsage) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.lastUpdated = lastUpdated;
        this.tags = tags;
        this.constants = constants;
        this.datatable = datatable;
        this.scenarioUsage = scenarioUsage;
        this.campaignUsage = campaignUsage;
        this.scenarioInCampaignUsage = scenarioInCampaignUsage;
        this.initShim = null;
    }

    private String descriptionInitialize() {
        return DataSetDto.super.description();
    }

    private Instant lastUpdatedInitialize() {
        return DataSetDto.super.lastUpdated();
    }

    private List<String> tagsInitialize() {
        return DataSetDto.super.tags();
    }

    private List<KeyValue> constantsInitialize() {
        return DataSetDto.super.constants();
    }

    private List<List<KeyValue>> datatableInitialize() {
        return DataSetDto.super.datatable();
    }

    private List<String> scenarioUsageInitialize() {
        return DataSetDto.super.scenarioUsage();
    }

    private List<String> campaignUsageInitialize() {
        return DataSetDto.super.campaignUsage();
    }

    private Map<String, Set<String>> scenarioInCampaignUsageInitialize() {
        return DataSetDto.super.scenarioInCampaignUsage();
    }

    @Override
    @JsonProperty(value="id", required=true)
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="name", required=true)
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description", required=true)
    public String description() {
        InitShim shim = this.initShim;
        return shim != null ? shim.description() : this.description;
    }

    @Override
    @JsonProperty(value="lastUpdated", required=true)
    public Instant lastUpdated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastUpdated() : this.lastUpdated;
    }

    @Override
    @JsonProperty(value="tags", required=true)
    public List<String> tags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tags() : this.tags;
    }

    @Override
    @JsonProperty(value="uniqueValues")
    public List<KeyValue> constants() {
        InitShim shim = this.initShim;
        return shim != null ? shim.constants() : this.constants;
    }

    @Override
    @JsonProperty(value="multipleValues")
    public List<List<KeyValue>> datatable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.datatable() : this.datatable;
    }

    @Override
    @JsonProperty(value="scenarioUsage", required=true)
    public List<String> scenarioUsage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scenarioUsage() : this.scenarioUsage;
    }

    @Override
    @JsonProperty(value="campaignUsage", required=true)
    public List<String> campaignUsage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.campaignUsage() : this.campaignUsage;
    }

    @Override
    @JsonProperty(value="scenarioInCampaignUsage", required=true)
    public Map<String, Set<String>> scenarioInCampaignUsage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scenarioInCampaignUsage() : this.scenarioInCampaignUsage;
    }

    public final ImmutableDataSetDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(newValue, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableDataSetDto(value, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(this.id, newValue, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableDataSetDto(this.id, this.name, newValue, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withLastUpdated(Instant value) {
        if (this.lastUpdated == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "lastUpdated");
        return new ImmutableDataSetDto(this.id, this.name, this.description, newValue, this.tags, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withTags(String ... elements) {
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, newValue, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, newValue, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withConstants(KeyValue ... elements) {
        List<KeyValue> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, newValue, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withConstants(Iterable<? extends KeyValue> elements) {
        if (this.constants == elements) {
            return this;
        }
        List<KeyValue> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, newValue, this.datatable, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    @SafeVarargs
    public final ImmutableDataSetDto withDatatable(List<KeyValue> ... elements) {
        List<List<KeyValue>> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, newValue, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withDatatable(Iterable<? extends List<KeyValue>> elements) {
        if (this.datatable == elements) {
            return this;
        }
        List<List<KeyValue>> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, newValue, this.scenarioUsage, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withScenarioUsage(String ... elements) {
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, newValue, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withScenarioUsage(Iterable<String> elements) {
        if (this.scenarioUsage == elements) {
            return this;
        }
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, newValue, this.campaignUsage, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withCampaignUsage(String ... elements) {
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, newValue, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withCampaignUsage(Iterable<String> elements) {
        if (this.campaignUsage == elements) {
            return this;
        }
        List<String> newValue = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(elements, true, false));
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, newValue, this.scenarioInCampaignUsage);
    }

    public final ImmutableDataSetDto withScenarioInCampaignUsage(Map<String, ? extends Set<String>> entries) {
        if (this.scenarioInCampaignUsage == entries) {
            return this;
        }
        Map<String, Set<String>> newValue = ImmutableDataSetDto.createUnmodifiableMap(true, false, entries);
        return new ImmutableDataSetDto(this.id, this.name, this.description, this.lastUpdated, this.tags, this.constants, this.datatable, this.scenarioUsage, this.campaignUsage, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDataSetDto && this.equalsByValue((ImmutableDataSetDto)another);
    }

    private boolean equalsByValue(ImmutableDataSetDto another) {
        return Objects.equals(this.id, another.id) && this.name.equals(another.name) && this.description.equals(another.description) && this.lastUpdated.equals(another.lastUpdated) && this.tags.equals(another.tags) && this.constants.equals(another.constants) && this.datatable.equals(another.datatable) && this.scenarioUsage.equals(another.scenarioUsage) && this.campaignUsage.equals(another.campaignUsage) && this.scenarioInCampaignUsage.equals(another.scenarioInCampaignUsage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.lastUpdated.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.constants.hashCode();
        h += (h << 5) + this.datatable.hashCode();
        h += (h << 5) + this.scenarioUsage.hashCode();
        h += (h << 5) + this.campaignUsage.hashCode();
        h += (h << 5) + this.scenarioInCampaignUsage.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DataSetDto{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("lastUpdated=").append(this.lastUpdated);
        builder.append(", ");
        builder.append("tags=").append(this.tags);
        builder.append(", ");
        builder.append("constants=").append(this.constants);
        builder.append(", ");
        builder.append("datatable=").append(this.datatable);
        builder.append(", ");
        builder.append("scenarioUsage=").append(this.scenarioUsage);
        builder.append(", ");
        builder.append("campaignUsage=").append(this.campaignUsage);
        builder.append(", ");
        builder.append("scenarioInCampaignUsage=").append(this.scenarioInCampaignUsage);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableDataSetDto fromJson(Json json) {
        Builder builder = ImmutableDataSetDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.lastUpdated != null) {
            builder.lastUpdated(json.lastUpdated);
        }
        if (json.tagsIsSet) {
            builder.addAllTags(json.tags);
        }
        if (json.constantsIsSet) {
            builder.addAllConstants(json.constants);
        }
        if (json.datatableIsSet) {
            builder.addAllDatatable(json.datatable);
        }
        if (json.scenarioUsageIsSet) {
            builder.addAllScenarioUsage(json.scenarioUsage);
        }
        if (json.campaignUsageIsSet) {
            builder.addAllCampaignUsage(json.campaignUsage);
        }
        if (json.scenarioInCampaignUsageIsSet) {
            builder.putAllScenarioInCampaignUsage(json.scenarioInCampaignUsage);
        }
        return builder.build();
    }

    public static ImmutableDataSetDto copyOf(DataSetDto instance) {
        if (instance instanceof ImmutableDataSetDto) {
            return (ImmutableDataSetDto)instance;
        }
        return ImmutableDataSetDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DataSetDto", generator="Immutables")
    private final class InitShim {
        private byte descriptionBuildStage = 0;
        private String description;
        private byte lastUpdatedBuildStage = 0;
        private Instant lastUpdated;
        private byte tagsBuildStage = 0;
        private List<String> tags;
        private byte constantsBuildStage = 0;
        private List<KeyValue> constants;
        private byte datatableBuildStage = 0;
        private List<List<KeyValue>> datatable;
        private byte scenarioUsageBuildStage = 0;
        private List<String> scenarioUsage;
        private byte campaignUsageBuildStage = 0;
        private List<String> campaignUsage;
        private byte scenarioInCampaignUsageBuildStage = 0;
        private Map<String, Set<String>> scenarioInCampaignUsage;

        private InitShim() {
        }

        String description() {
            if (this.descriptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionBuildStage == 0) {
                this.descriptionBuildStage = (byte)-1;
                this.description = Objects.requireNonNull(ImmutableDataSetDto.this.descriptionInitialize(), "description");
                this.descriptionBuildStage = 1;
            }
            return this.description;
        }

        void description(String description) {
            this.description = description;
            this.descriptionBuildStage = 1;
        }

        Instant lastUpdated() {
            if (this.lastUpdatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastUpdatedBuildStage == 0) {
                this.lastUpdatedBuildStage = (byte)-1;
                this.lastUpdated = Objects.requireNonNull(ImmutableDataSetDto.this.lastUpdatedInitialize(), "lastUpdated");
                this.lastUpdatedBuildStage = 1;
            }
            return this.lastUpdated;
        }

        void lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.lastUpdatedBuildStage = 1;
        }

        List<String> tags() {
            if (this.tagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsBuildStage == 0) {
                this.tagsBuildStage = (byte)-1;
                this.tags = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.tagsInitialize(), true, false));
                this.tagsBuildStage = 1;
            }
            return this.tags;
        }

        void tags(List<String> tags) {
            this.tags = tags;
            this.tagsBuildStage = 1;
        }

        List<KeyValue> constants() {
            if (this.constantsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.constantsBuildStage == 0) {
                this.constantsBuildStage = (byte)-1;
                this.constants = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.constantsInitialize(), true, false));
                this.constantsBuildStage = 1;
            }
            return this.constants;
        }

        void constants(List<KeyValue> constants) {
            this.constants = constants;
            this.constantsBuildStage = 1;
        }

        List<List<KeyValue>> datatable() {
            if (this.datatableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.datatableBuildStage == 0) {
                this.datatableBuildStage = (byte)-1;
                this.datatable = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.datatableInitialize(), true, false));
                this.datatableBuildStage = 1;
            }
            return this.datatable;
        }

        void datatable(List<List<KeyValue>> datatable) {
            this.datatable = datatable;
            this.datatableBuildStage = 1;
        }

        List<String> scenarioUsage() {
            if (this.scenarioUsageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scenarioUsageBuildStage == 0) {
                this.scenarioUsageBuildStage = (byte)-1;
                this.scenarioUsage = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.scenarioUsageInitialize(), true, false));
                this.scenarioUsageBuildStage = 1;
            }
            return this.scenarioUsage;
        }

        void scenarioUsage(List<String> scenarioUsage) {
            this.scenarioUsage = scenarioUsage;
            this.scenarioUsageBuildStage = 1;
        }

        List<String> campaignUsage() {
            if (this.campaignUsageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.campaignUsageBuildStage == 0) {
                this.campaignUsageBuildStage = (byte)-1;
                this.campaignUsage = ImmutableDataSetDto.createUnmodifiableList(false, ImmutableDataSetDto.createSafeList(ImmutableDataSetDto.this.campaignUsageInitialize(), true, false));
                this.campaignUsageBuildStage = 1;
            }
            return this.campaignUsage;
        }

        void campaignUsage(List<String> campaignUsage) {
            this.campaignUsage = campaignUsage;
            this.campaignUsageBuildStage = 1;
        }

        Map<String, Set<String>> scenarioInCampaignUsage() {
            if (this.scenarioInCampaignUsageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scenarioInCampaignUsageBuildStage == 0) {
                this.scenarioInCampaignUsageBuildStage = (byte)-1;
                this.scenarioInCampaignUsage = ImmutableDataSetDto.createUnmodifiableMap(true, false, ImmutableDataSetDto.this.scenarioInCampaignUsageInitialize());
                this.scenarioInCampaignUsageBuildStage = 1;
            }
            return this.scenarioInCampaignUsage;
        }

        void scenarioInCampaignUsage(Map<String, Set<String>> scenarioInCampaignUsage) {
            this.scenarioInCampaignUsage = scenarioInCampaignUsage;
            this.scenarioInCampaignUsageBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.descriptionBuildStage == -1) {
                attributes.add("description");
            }
            if (this.lastUpdatedBuildStage == -1) {
                attributes.add("lastUpdated");
            }
            if (this.tagsBuildStage == -1) {
                attributes.add("tags");
            }
            if (this.constantsBuildStage == -1) {
                attributes.add("constants");
            }
            if (this.datatableBuildStage == -1) {
                attributes.add("datatable");
            }
            if (this.scenarioUsageBuildStage == -1) {
                attributes.add("scenarioUsage");
            }
            if (this.campaignUsageBuildStage == -1) {
                attributes.add("campaignUsage");
            }
            if (this.scenarioInCampaignUsageBuildStage == -1) {
                attributes.add("scenarioInCampaignUsage");
            }
            return "Cannot build DataSetDto, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="DataSetDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_TAGS = 1L;
        private static final long OPT_BIT_CONSTANTS = 2L;
        private static final long OPT_BIT_DATATABLE = 4L;
        private static final long OPT_BIT_SCENARIO_USAGE = 8L;
        private static final long OPT_BIT_CAMPAIGN_USAGE = 16L;
        private static final long OPT_BIT_SCENARIO_IN_CAMPAIGN_USAGE = 32L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private Instant lastUpdated;
        private List<String> tags = new ArrayList<String>();
        private List<KeyValue> constants = new ArrayList<KeyValue>();
        private List<List<KeyValue>> datatable = new ArrayList<List<KeyValue>>();
        private List<String> scenarioUsage = new ArrayList<String>();
        private List<String> campaignUsage = new ArrayList<String>();
        private Map<String, Set<String>> scenarioInCampaignUsage = new LinkedHashMap<String, Set<String>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DataSetDto instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.name(instance.name());
            this.description(instance.description());
            this.lastUpdated(instance.lastUpdated());
            this.addAllTags(instance.tags());
            this.addAllConstants(instance.constants());
            this.addAllDatatable(instance.datatable());
            this.addAllScenarioUsage(instance.scenarioUsage());
            this.addAllCampaignUsage(instance.campaignUsage());
            this.putAllScenarioInCampaignUsage(instance.scenarioInCampaignUsage());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id", required=true)
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="name", required=true)
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description", required=true)
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="lastUpdated", required=true)
        @CanIgnoreReturnValue
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = Objects.requireNonNull(lastUpdated, "lastUpdated");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="tags", required=true)
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConstants(KeyValue element) {
            this.constants.add(Objects.requireNonNull(element, "constants element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConstants(KeyValue ... elements) {
            for (KeyValue element : elements) {
                this.constants.add(Objects.requireNonNull(element, "constants element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="uniqueValues")
        @CanIgnoreReturnValue
        public final Builder constants(Iterable<? extends KeyValue> elements) {
            this.constants.clear();
            return this.addAllConstants(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConstants(Iterable<? extends KeyValue> elements) {
            for (KeyValue keyValue : elements) {
                this.constants.add(Objects.requireNonNull(keyValue, "constants element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDatatable(List<KeyValue> element) {
            this.datatable.add(Objects.requireNonNull(element, "datatable element"));
            this.optBits |= 4L;
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addDatatable(List<KeyValue> ... elements) {
            for (List<KeyValue> element : elements) {
                this.datatable.add(Objects.requireNonNull(element, "datatable element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="multipleValues")
        @CanIgnoreReturnValue
        public final Builder datatable(Iterable<? extends List<KeyValue>> elements) {
            this.datatable.clear();
            return this.addAllDatatable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDatatable(Iterable<? extends List<KeyValue>> elements) {
            for (List<KeyValue> list : elements) {
                this.datatable.add(Objects.requireNonNull(list, "datatable element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addScenarioUsage(String element) {
            this.scenarioUsage.add(Objects.requireNonNull(element, "scenarioUsage element"));
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addScenarioUsage(String ... elements) {
            for (String element : elements) {
                this.scenarioUsage.add(Objects.requireNonNull(element, "scenarioUsage element"));
            }
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="scenarioUsage", required=true)
        @CanIgnoreReturnValue
        public final Builder scenarioUsage(Iterable<String> elements) {
            this.scenarioUsage.clear();
            return this.addAllScenarioUsage(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllScenarioUsage(Iterable<String> elements) {
            for (String element : elements) {
                this.scenarioUsage.add(Objects.requireNonNull(element, "scenarioUsage element"));
            }
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCampaignUsage(String element) {
            this.campaignUsage.add(Objects.requireNonNull(element, "campaignUsage element"));
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCampaignUsage(String ... elements) {
            for (String element : elements) {
                this.campaignUsage.add(Objects.requireNonNull(element, "campaignUsage element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="campaignUsage", required=true)
        @CanIgnoreReturnValue
        public final Builder campaignUsage(Iterable<String> elements) {
            this.campaignUsage.clear();
            return this.addAllCampaignUsage(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCampaignUsage(Iterable<String> elements) {
            for (String element : elements) {
                this.campaignUsage.add(Objects.requireNonNull(element, "campaignUsage element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putScenarioInCampaignUsage(String key, Set<String> value) {
            this.scenarioInCampaignUsage.put(Objects.requireNonNull(key, "scenarioInCampaignUsage key"), Objects.requireNonNull(value, value == null ? "scenarioInCampaignUsage value for key: " + key : null));
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putScenarioInCampaignUsage(Map.Entry<String, ? extends Set<String>> entry) {
            Set<String> v;
            String k = entry.getKey();
            this.scenarioInCampaignUsage.put(Objects.requireNonNull(k, "scenarioInCampaignUsage key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "scenarioInCampaignUsage value for key: " + k : null));
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty(value="scenarioInCampaignUsage", required=true)
        @CanIgnoreReturnValue
        public final Builder scenarioInCampaignUsage(Map<String, ? extends Set<String>> entries) {
            this.scenarioInCampaignUsage.clear();
            this.optBits |= 0x20L;
            return this.putAllScenarioInCampaignUsage(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllScenarioInCampaignUsage(Map<String, ? extends Set<String>> entries) {
            for (Map.Entry<String, ? extends Set<String>> e : entries.entrySet()) {
                Set<String> v;
                String k = e.getKey();
                this.scenarioInCampaignUsage.put(Objects.requireNonNull(k, "scenarioInCampaignUsage key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "scenarioInCampaignUsage value for key: " + k : null));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableDataSetDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDataSetDto(this);
        }

        private boolean tagsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean constantsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean datatableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean scenarioUsageIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean campaignUsageIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean scenarioInCampaignUsageIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build DataSetDto, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="DataSetDto", generator="Immutables")
    static final class Json
    implements DataSetDto {
        @JsonIgnore
        @Nullable
        Optional<String> id = Optional.empty();
        @JsonIgnore
        @Nullable
        String name;
        @JsonIgnore
        @Nullable
        String description;
        @JsonIgnore
        @Nullable
        Instant lastUpdated;
        @JsonIgnore
        @Nullable
        List<String> tags = Collections.emptyList();
        @JsonIgnore
        boolean tagsIsSet;
        @JsonIgnore
        @Nullable
        List<KeyValue> constants = Collections.emptyList();
        @JsonIgnore
        boolean constantsIsSet;
        @JsonIgnore
        @Nullable
        List<List<KeyValue>> datatable = Collections.emptyList();
        @JsonIgnore
        boolean datatableIsSet;
        @JsonIgnore
        @Nullable
        List<String> scenarioUsage = Collections.emptyList();
        @JsonIgnore
        boolean scenarioUsageIsSet;
        @JsonIgnore
        @Nullable
        List<String> campaignUsage = Collections.emptyList();
        @JsonIgnore
        boolean campaignUsageIsSet;
        @JsonIgnore
        @Nullable
        Map<String, Set<String>> scenarioInCampaignUsage = Collections.emptyMap();
        @JsonIgnore
        boolean scenarioInCampaignUsageIsSet;

        Json() {
        }

        @JsonProperty(value="id", required=true)
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="name", required=true)
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description", required=true)
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="lastUpdated", required=true)
        public void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @JsonProperty(value="tags", required=true)
        public void setTags(List<String> tags) {
            this.tags = tags;
            this.tagsIsSet = null != tags;
        }

        @JsonProperty(value="uniqueValues")
        public void setConstants(List<KeyValue> constants) {
            this.constants = constants;
            this.constantsIsSet = null != constants;
        }

        @JsonProperty(value="multipleValues")
        public void setDatatable(List<List<KeyValue>> datatable) {
            this.datatable = datatable;
            this.datatableIsSet = null != datatable;
        }

        @JsonProperty(value="scenarioUsage", required=true)
        public void setScenarioUsage(List<String> scenarioUsage) {
            this.scenarioUsage = scenarioUsage;
            this.scenarioUsageIsSet = null != scenarioUsage;
        }

        @JsonProperty(value="campaignUsage", required=true)
        public void setCampaignUsage(List<String> campaignUsage) {
            this.campaignUsage = campaignUsage;
            this.campaignUsageIsSet = null != campaignUsage;
        }

        @JsonProperty(value="scenarioInCampaignUsage", required=true)
        public void setScenarioInCampaignUsage(Map<String, Set<String>> scenarioInCampaignUsage) {
            this.scenarioInCampaignUsage = scenarioInCampaignUsage;
            this.scenarioInCampaignUsageIsSet = null != scenarioInCampaignUsage;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant lastUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<KeyValue> constants() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<List<KeyValue>> datatable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> scenarioUsage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> campaignUsage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Set<String>> scenarioInCampaignUsage() {
            throw new UnsupportedOperationException();
        }
    }
}

