/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.dataset.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import fr.enedis.chutney.dataset.api.KeyValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyValue", generator="Immutables")
@Immutable
public final class ImmutableKeyValue
implements KeyValue {
    private final String key;
    private final String value;

    private ImmutableKeyValue(Builder builder) {
        this.key = builder.key;
        this.value = builder.value != null ? builder.value : Objects.requireNonNull(KeyValue.super.value(), "value");
    }

    private ImmutableKeyValue(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    @JsonProperty(value="key", required=true)
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="value", required=true)
    public String value() {
        return this.value;
    }

    public final ImmutableKeyValue withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyValue(newValue, this.value);
    }

    public final ImmutableKeyValue withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableKeyValue(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyValue && this.equalsByValue((ImmutableKeyValue)another);
    }

    private boolean equalsByValue(ImmutableKeyValue another) {
        return this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "KeyValue{key=" + this.key + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableKeyValue fromJson(Json json) {
        Builder builder = ImmutableKeyValue.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableKeyValue copyOf(KeyValue instance) {
        if (instance instanceof ImmutableKeyValue) {
            return (ImmutableKeyValue)instance;
        }
        return ImmutableKeyValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private String key;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.value(instance.value());
            return this;
        }

        @JsonProperty(value="key", required=true)
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value", required=true)
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        public ImmutableKeyValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyValue(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build KeyValue, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="KeyValue", generator="Immutables")
    static final class Json
    implements KeyValue {
        @JsonIgnore
        @Nullable
        String key;
        @JsonIgnore
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty(value="key", required=true)
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="value", required=true)
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }
    }
}

