/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.dataset.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import fr.enedis.chutney.dataset.api.ImmutableKeyValue;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableKeyValue.class)
@JsonDeserialize(as=ImmutableKeyValue.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface KeyValue {
    public String key();

    @Value.Default
    default public String value() {
        return "";
    }

    public static List<KeyValue> fromMap(Map<String, String> map) {
        return map.keySet().stream().map(key -> ImmutableKeyValue.builder().key((String)key).value((String)map.get(key)).build()).toList();
    }

    public static Map<String, String> toMap(List<KeyValue> list) {
        return Optional.ofNullable(list).map(l -> l.stream().filter(kv -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{kv.key()})).collect(Collectors.toUnmodifiableMap(KeyValue::key, KeyValue::value, (k1, k2) -> k1))).orElseGet(Map::of);
    }
}

