/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.design.api.editionlock;

import fr.enedis.chutney.design.api.editionlock.ImmutableTestCaseEditionDto;
import fr.enedis.chutney.design.api.editionlock.TestCaseEditionDto;
import fr.enedis.chutney.design.domain.editionlock.TestCaseEdition;
import fr.enedis.chutney.design.domain.editionlock.TestCaseEditionsService;
import fr.enedis.chutney.security.infra.SpringUserService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/editions/testcases"})
public class TestCaseEditionController {
    static final String BASE_URL = "/api/v1/editions/testcases";
    private final TestCaseEditionsService testCaseEditionsService;
    private final SpringUserService userService;

    public TestCaseEditionController(TestCaseEditionsService testCaseEditionsService, SpringUserService userService) {
        this.testCaseEditionsService = testCaseEditionsService;
        this.userService = userService;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/{testCaseId}"}, produces={"application/json"})
    public List<TestCaseEditionDto> testCasesEditions(@PathVariable(value="testCaseId") String testCaseId) {
        return this.testCaseEditionsService.getTestCaseEditions(testCaseId).stream().map(TestCaseEditionController::toDto).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @PostMapping(path={"/{testCaseId}"}, produces={"application/json"})
    public TestCaseEditionDto editTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        return TestCaseEditionController.toDto(this.testCaseEditionsService.editTestCase(testCaseId, this.userService.currentUser().getId()));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @DeleteMapping(path={"/{testCaseId}"})
    public void endTestCaseEdition(@PathVariable(value="testCaseId") String testCaseId) {
        this.testCaseEditionsService.endTestCaseEdition(testCaseId, this.userService.currentUser().getId());
    }

    private static TestCaseEditionDto toDto(TestCaseEdition tcEdition) {
        return ImmutableTestCaseEditionDto.builder().testCaseId(tcEdition.testCaseMetadata.id()).testCaseVersion(tcEdition.testCaseMetadata.version()).editionUser(tcEdition.editor).editionStartDate(tcEdition.startDate).build();
    }
}

