/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.design.api.plugins.linkifier;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import fr.enedis.chutney.design.api.plugins.linkifier.LinkifierDto;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LinkifierDto", generator="Immutables")
@Immutable
public final class ImmutableLinkifierDto
implements LinkifierDto {
    private final String pattern;
    private final String link;
    private final String id;

    private ImmutableLinkifierDto(String pattern, String link, String id) {
        this.pattern = pattern;
        this.link = link;
        this.id = id;
    }

    @Override
    @JsonProperty(value="pattern", required=true)
    public String pattern() {
        return this.pattern;
    }

    @Override
    @JsonProperty(value="link", required=true)
    public String link() {
        return this.link;
    }

    @Override
    @JsonProperty(value="id", required=true)
    public String id() {
        return this.id;
    }

    public final ImmutableLinkifierDto withPattern(String value) {
        String newValue = Objects.requireNonNull(value, "pattern");
        if (this.pattern.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkifierDto(newValue, this.link, this.id);
    }

    public final ImmutableLinkifierDto withLink(String value) {
        String newValue = Objects.requireNonNull(value, "link");
        if (this.link.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkifierDto(this.pattern, newValue, this.id);
    }

    public final ImmutableLinkifierDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkifierDto(this.pattern, this.link, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkifierDto && this.equalsByValue((ImmutableLinkifierDto)another);
    }

    private boolean equalsByValue(ImmutableLinkifierDto another) {
        return this.pattern.equals(another.pattern) && this.link.equals(another.link) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pattern.hashCode();
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "LinkifierDto{pattern=" + this.pattern + ", link=" + this.link + ", id=" + this.id + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableLinkifierDto fromJson(Json json) {
        Builder builder = ImmutableLinkifierDto.builder();
        if (json.pattern != null) {
            builder.pattern(json.pattern);
        }
        if (json.link != null) {
            builder.link(json.link);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        return builder.build();
    }

    public static ImmutableLinkifierDto copyOf(LinkifierDto instance) {
        if (instance instanceof ImmutableLinkifierDto) {
            return (ImmutableLinkifierDto)instance;
        }
        return ImmutableLinkifierDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LinkifierDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATTERN = 1L;
        private static final long INIT_BIT_LINK = 2L;
        private static final long INIT_BIT_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private String pattern;
        @Nullable
        private String link;
        @Nullable
        private String id;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LinkifierDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.pattern(instance.pattern());
            this.link(instance.link());
            this.id(instance.id());
            return this;
        }

        @JsonProperty(value="pattern", required=true)
        @CanIgnoreReturnValue
        public final Builder pattern(String pattern) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="link", required=true)
        @CanIgnoreReturnValue
        public final Builder link(String link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="id", required=true)
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableLinkifierDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkifierDto(this.pattern, this.link, this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pattern");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("link");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build LinkifierDto, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="LinkifierDto", generator="Immutables")
    static final class Json
    implements LinkifierDto {
        @JsonIgnore
        @Nullable
        String pattern;
        @JsonIgnore
        @Nullable
        String link;
        @JsonIgnore
        @Nullable
        String id;

        Json() {
        }

        @JsonProperty(value="pattern", required=true)
        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @JsonProperty(value="link", required=true)
        public void setLink(String link) {
            this.link = link;
        }

        @JsonProperty(value="id", required=true)
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String pattern() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String link() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }
    }
}

