/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api;

import fr.enedis.chutney.campaign.api.dto.CampaignExecutionReportDto;
import fr.enedis.chutney.campaign.api.dto.CampaignExecutionReportMapper;
import fr.enedis.chutney.dataset.api.DataSetMapper;
import fr.enedis.chutney.dataset.api.ExecutionDatasetDto;
import fr.enedis.chutney.dataset.domain.DataSetRepository;
import fr.enedis.chutney.execution.api.CampaignExecutionApiMapper;
import fr.enedis.chutney.execution.api.CampaignExecutionReportSummaryDto;
import fr.enedis.chutney.execution.api.report.surefire.SurefireCampaignExecutionReportBuilder;
import fr.enedis.chutney.execution.api.report.surefire.SurefireScenarioExecutionReportBuilder;
import fr.enedis.chutney.execution.domain.campaign.CampaignExecutionEngine;
import fr.enedis.chutney.security.infra.SpringUserService;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/execution/v1"})
public class CampaignExecutionUiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignExecutionUiController.class);
    static final String BASE_URL = "/api/ui/campaign/execution/v1";
    private final CampaignExecutionEngine campaignExecutionEngine;
    private final SurefireCampaignExecutionReportBuilder surefireCampaignExecutionReportBuilder;
    private final SpringUserService userService;
    private final CampaignExecutionApiMapper campaignExecutionApiMapper;
    private final DataSetRepository datasetRepository;

    public CampaignExecutionUiController(CampaignExecutionEngine campaignExecutionEngine, SurefireScenarioExecutionReportBuilder surefireScenarioExecutionReportBuilder, SpringUserService userService, CampaignExecutionApiMapper campaignExecutionApiMapper, DataSetRepository datasetRepository) {
        this.campaignExecutionEngine = campaignExecutionEngine;
        this.surefireCampaignExecutionReportBuilder = new SurefireCampaignExecutionReportBuilder(surefireScenarioExecutionReportBuilder);
        this.userService = userService;
        this.campaignExecutionApiMapper = campaignExecutionApiMapper;
        this.datasetRepository = datasetRepository;
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/{campaignName}/lastExecution", "/{campaignName}/{env}/lastExecution"}, produces={"application/json"})
    public CampaignExecutionReportSummaryDto getLastCampaignExecution(@PathVariable(value="campaignId") Long campaignId) {
        CampaignExecution lastCampaignExecution = this.campaignExecutionEngine.getLastCampaignExecution(campaignId);
        return this.campaignExecutionApiMapper.toCampaignExecutionReportSummaryDto(lastCampaignExecution);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_EXECUTE')")
    @GetMapping(path={"/{campaignName}", "/{campaignName}/{env}"}, produces={"application/json"})
    public List<CampaignExecutionReportDto> executeCampaignByName(@PathVariable(value="campaignName") String campaignName, @PathVariable(value="env") Optional<String> environment) {
        String userId = this.userService.currentUser().getId();
        List<CampaignExecution> reports = this.campaignExecutionEngine.executeByName(campaignName, environment.orElse(null), userId);
        return reports.stream().map(CampaignExecutionReportMapper::toDto).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_EXECUTE')")
    @PostMapping(path={"/replay/{campaignExecutionId}"}, produces={"application/json"})
    public CampaignExecutionReportDto replayFailedScenario(@PathVariable(value="campaignExecutionId") Long campaignExecutionId) {
        String userId = this.userService.currentUser().getId();
        CampaignExecution newExecution = this.campaignExecutionEngine.replayFailedScenariosExecutionsForExecution(campaignExecutionId, userId);
        return CampaignExecutionReportMapper.toDto(newExecution);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_EXECUTE')")
    @GetMapping(path={"/{campaignPattern}/surefire", "/{campaignPattern}/surefire/{env}"}, produces={"application/zip"})
    public byte[] executeCampaignsByPatternWithSurefireReport(HttpServletResponse response, @PathVariable(value="campaignPattern") String campaignPattern, @PathVariable(value="env") Optional<String> environment) {
        String userId = this.userService.currentUser().getId();
        response.addHeader("Content-Disposition", "attachment; filename=\"surefire-report.zip\"");
        List<CampaignExecution> reports = this.campaignExecutionEngine.executeByName(campaignPattern, environment.orElse(null), userId);
        return this.surefireCampaignExecutionReportBuilder.createReport(reports);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_EXECUTE')")
    @PostMapping(path={"/{executionId}/stop"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void stopExecution(@PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Stop campaign execution {}", (Object)executionId);
        this.campaignExecutionEngine.stopExecution(executionId);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_EXECUTE')")
    @PostMapping(path={"/byID/{campaignId}", "/byID/{campaignId}/{env}"}, produces={"application/json"})
    public CampaignExecutionReportDto executeCampaignById(@PathVariable(value="campaignId") Long campaignId, @PathVariable(value="env") Optional<String> environment, @RequestBody ExecutionDatasetDto dataset) {
        String userId = this.userService.currentUser().getId();
        DataSet ds = DataSetMapper.fromExecutionDatasetDto(dataset, this.datasetRepository::findById);
        CampaignExecution report = this.campaignExecutionEngine.executeById(campaignId, environment.orElse(null), ds, userId);
        return CampaignExecutionReportMapper.toDto(report);
    }
}

