/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import fr.enedis.chutney.execution.api.ExecutionSummaryDto;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExecutionSummaryDto", generator="Immutables")
@Immutable
public final class ImmutableExecutionSummaryDto
implements ExecutionSummaryDto {
    private final LocalDateTime time;
    private final long duration;
    private final ServerReportStatus status;
    @Nullable
    private final String info;
    @Nullable
    private final String error;
    private final String testCaseTitle;
    private final String environment;
    @Nullable
    private final DataSet dataset;
    private final String user;
    @Nullable
    private final CampaignExecution campaignReport;
    @Nullable
    private final Set<String> tags;
    private final Long executionId;
    private final String scenarioId;

    private ImmutableExecutionSummaryDto(LocalDateTime time, long duration, ServerReportStatus status, @Nullable String info, @Nullable String error, String testCaseTitle, String environment, @Nullable DataSet dataset, String user, @Nullable CampaignExecution campaignReport, @Nullable Set<String> tags, Long executionId, String scenarioId) {
        this.time = time;
        this.duration = duration;
        this.status = status;
        this.info = info;
        this.error = error;
        this.testCaseTitle = testCaseTitle;
        this.environment = environment;
        this.dataset = dataset;
        this.user = user;
        this.campaignReport = campaignReport;
        this.tags = tags;
        this.executionId = executionId;
        this.scenarioId = scenarioId;
    }

    @JsonProperty(value="time", required=true)
    public LocalDateTime time() {
        return this.time;
    }

    @JsonProperty(value="duration", required=true)
    public long duration() {
        return this.duration;
    }

    @JsonProperty(value="status", required=true)
    public ServerReportStatus status() {
        return this.status;
    }

    @JsonProperty(value="info", required=true)
    public Optional<String> info() {
        return Optional.ofNullable(this.info);
    }

    @JsonProperty(value="error", required=true)
    public Optional<String> error() {
        return Optional.ofNullable(this.error);
    }

    @JsonProperty(value="testCaseTitle", required=true)
    public String testCaseTitle() {
        return this.testCaseTitle;
    }

    @JsonProperty(value="environment", required=true)
    public String environment() {
        return this.environment;
    }

    @JsonProperty(value="dataset", required=true)
    public Optional<DataSet> dataset() {
        return Optional.ofNullable(this.dataset);
    }

    @JsonProperty(value="user", required=true)
    public String user() {
        return this.user;
    }

    @JsonProperty(value="campaignReport", required=true)
    public Optional<CampaignExecution> campaignReport() {
        return Optional.ofNullable(this.campaignReport);
    }

    @JsonProperty(value="tags", required=true)
    public Optional<Set<String>> tags() {
        return Optional.ofNullable(this.tags);
    }

    @JsonProperty(value="executionId", required=true)
    public Long executionId() {
        return this.executionId;
    }

    @JsonProperty(value="scenarioId", required=true)
    public String scenarioId() {
        return this.scenarioId;
    }

    public final ImmutableExecutionSummaryDto withTime(LocalDateTime value) {
        if (this.time == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "time");
        return new ImmutableExecutionSummaryDto(newValue, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withDuration(long value) {
        if (this.duration == value) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, value, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withStatus(ServerReportStatus value) {
        ServerReportStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, newValue, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withInfo(String value) {
        String newValue = Objects.requireNonNull(value, "info");
        if (Objects.equals(this.info, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, newValue, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withInfo(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.info, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, value, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withError(String value) {
        String newValue = Objects.requireNonNull(value, "error");
        if (Objects.equals(this.error, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, newValue, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withError(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, value, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withTestCaseTitle(String value) {
        String newValue = Objects.requireNonNull(value, "testCaseTitle");
        if (this.testCaseTitle.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, newValue, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withEnvironment(String value) {
        String newValue = Objects.requireNonNull(value, "environment");
        if (this.environment.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, newValue, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withDataset(DataSet value) {
        DataSet newValue = Objects.requireNonNull(value, "dataset");
        if (Objects.equals(this.dataset, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, newValue, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withDataset(Optional<? extends DataSet> optional) {
        DataSet value = optional.orElse(null);
        if (Objects.equals(this.dataset, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, value, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (this.user.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, newValue, this.campaignReport, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withCampaignReport(CampaignExecution value) {
        CampaignExecution newValue = Objects.requireNonNull(value, "campaignReport");
        if (Objects.equals(this.campaignReport, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, newValue, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withCampaignReport(Optional<? extends CampaignExecution> optional) {
        CampaignExecution value = optional.orElse(null);
        if (Objects.equals(this.campaignReport, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, value, this.tags, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withTags(Set<String> value) {
        Set<String> newValue = Objects.requireNonNull(value, "tags");
        if (Objects.equals(this.tags, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, newValue, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withTags(Optional<? extends Set<String>> optional) {
        Set value = optional.orElse(null);
        if (Objects.equals(this.tags, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, value, this.executionId, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withExecutionId(Long value) {
        Long newValue = Objects.requireNonNull(value, "executionId");
        if (this.executionId.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, newValue, this.scenarioId);
    }

    public final ImmutableExecutionSummaryDto withScenarioId(String value) {
        String newValue = Objects.requireNonNull(value, "scenarioId");
        if (this.scenarioId.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutionSummaryDto && this.equalsByValue((ImmutableExecutionSummaryDto)another);
    }

    private boolean equalsByValue(ImmutableExecutionSummaryDto another) {
        return this.time.equals(another.time) && this.duration == another.duration && this.status.equals((Object)another.status) && Objects.equals(this.info, another.info) && Objects.equals(this.error, another.error) && this.testCaseTitle.equals(another.testCaseTitle) && this.environment.equals(another.environment) && Objects.equals(this.dataset, another.dataset) && this.user.equals(another.user) && Objects.equals(this.campaignReport, another.campaignReport) && Objects.equals(this.tags, another.tags) && this.executionId.equals(another.executionId) && this.scenarioId.equals(another.scenarioId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.time.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.duration);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.info);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.testCaseTitle.hashCode();
        h += (h << 5) + this.environment.hashCode();
        h += (h << 5) + Objects.hashCode(this.dataset);
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + Objects.hashCode(this.campaignReport);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + this.executionId.hashCode();
        h += (h << 5) + this.scenarioId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExecutionSummaryDto").omitNullValues().add("time", (Object)this.time).add("duration", this.duration).add("status", (Object)this.status).add("info", (Object)this.info).add("error", (Object)this.error).add("testCaseTitle", (Object)this.testCaseTitle).add("environment", (Object)this.environment).add("dataset", (Object)this.dataset).add("user", (Object)this.user).add("campaignReport", (Object)this.campaignReport).add("tags", this.tags).add("executionId", (Object)this.executionId).add("scenarioId", (Object)this.scenarioId).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableExecutionSummaryDto fromJson(Json json) {
        Builder builder = ImmutableExecutionSummaryDto.builder();
        if (json.time != null) {
            builder.time(json.time);
        }
        if (json.durationIsSet) {
            builder.duration(json.duration);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.info != null) {
            builder.info(json.info);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.testCaseTitle != null) {
            builder.testCaseTitle(json.testCaseTitle);
        }
        if (json.environment != null) {
            builder.environment(json.environment);
        }
        if (json.dataset != null) {
            builder.dataset(json.dataset);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.campaignReport != null) {
            builder.campaignReport(json.campaignReport);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.executionId != null) {
            builder.executionId(json.executionId);
        }
        if (json.scenarioId != null) {
            builder.scenarioId(json.scenarioId);
        }
        return builder.build();
    }

    public static ImmutableExecutionSummaryDto copyOf(ExecutionSummaryDto instance) {
        if (instance instanceof ImmutableExecutionSummaryDto) {
            return (ImmutableExecutionSummaryDto)instance;
        }
        return ImmutableExecutionSummaryDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecutionSummaryDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIME = 1L;
        private static final long INIT_BIT_DURATION = 2L;
        private static final long INIT_BIT_STATUS = 4L;
        private static final long INIT_BIT_TEST_CASE_TITLE = 8L;
        private static final long INIT_BIT_ENVIRONMENT = 16L;
        private static final long INIT_BIT_USER = 32L;
        private static final long INIT_BIT_EXECUTION_ID = 64L;
        private static final long INIT_BIT_SCENARIO_ID = 128L;
        private long initBits = 255L;
        @Nullable
        private LocalDateTime time;
        private long duration;
        @Nullable
        private ServerReportStatus status;
        @Nullable
        private String info;
        @Nullable
        private String error;
        @Nullable
        private String testCaseTitle;
        @Nullable
        private String environment;
        @Nullable
        private DataSet dataset;
        @Nullable
        private String user;
        @Nullable
        private CampaignExecution campaignReport;
        @Nullable
        private Set<String> tags;
        @Nullable
        private Long executionId;
        @Nullable
        private String scenarioId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionHistory.WithScenario instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionSummaryDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionHistory.Attached instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionHistory.ExecutionProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional infoOptional;
            Optional campaignReportOptional;
            Optional datasetOptional;
            Optional tagsOptional;
            Optional errorOptional;
            ExecutionHistory.WithScenario instance;
            long bits = 0L;
            if (object instanceof ExecutionHistory.WithScenario) {
                instance = (ExecutionHistory.WithScenario)object;
                if ((bits & 0x400L) == 0L) {
                    this.scenarioId(instance.scenarioId());
                    bits |= 0x400L;
                }
            }
            if (object instanceof ExecutionSummaryDto) {
                instance = (ExecutionSummaryDto)object;
                if ((bits & 1L) == 0L) {
                    errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    tagsOptional = instance.tags();
                    if (tagsOptional.isPresent()) {
                        this.tags(tagsOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.duration(instance.duration());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.executionId(instance.executionId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.environment(instance.environment());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.time(instance.time());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.testCaseTitle(instance.testCaseTitle());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    datasetOptional = instance.dataset();
                    if (datasetOptional.isPresent()) {
                        this.dataset(datasetOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.user(instance.user());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    campaignReportOptional = instance.campaignReport();
                    if (campaignReportOptional.isPresent()) {
                        this.campaignReport(campaignReportOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.scenarioId(instance.scenarioId());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                    bits |= 0x1000L;
                }
            }
            if (object instanceof ExecutionHistory.Attached) {
                instance = (ExecutionHistory.Attached)object;
                if ((bits & 8L) == 0L) {
                    this.executionId(instance.executionId());
                    bits |= 8L;
                }
            }
            if (object instanceof ExecutionHistory.ExecutionProperties) {
                instance = (ExecutionHistory.ExecutionProperties)object;
                if ((bits & 4L) == 0L) {
                    this.duration(instance.duration());
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.environment(instance.environment());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.time(instance.time());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.testCaseTitle(instance.testCaseTitle());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    datasetOptional = instance.dataset();
                    if (datasetOptional.isPresent()) {
                        this.dataset(datasetOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.user(instance.user());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    campaignReportOptional = instance.campaignReport();
                    if (campaignReportOptional.isPresent()) {
                        this.campaignReport(campaignReportOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 2L) == 0L) {
                    tagsOptional = instance.tags();
                    if (tagsOptional.isPresent()) {
                        this.tags(tagsOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                    bits |= 0x1000L;
                }
            }
        }

        @JsonProperty(value="time", required=true)
        @CanIgnoreReturnValue
        public final Builder time(LocalDateTime time) {
            this.time = Objects.requireNonNull(time, "time");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="duration", required=true)
        @CanIgnoreReturnValue
        public final Builder duration(long duration) {
            this.duration = duration;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="status", required=true)
        @CanIgnoreReturnValue
        public final Builder status(ServerReportStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder info(String info) {
            this.info = Objects.requireNonNull(info, "info");
            return this;
        }

        @JsonProperty(value="info", required=true)
        @CanIgnoreReturnValue
        public final Builder info(Optional<String> info) {
            this.info = info.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(String error) {
            this.error = Objects.requireNonNull(error, "error");
            return this;
        }

        @JsonProperty(value="error", required=true)
        @CanIgnoreReturnValue
        public final Builder error(Optional<String> error) {
            this.error = error.orElse(null);
            return this;
        }

        @JsonProperty(value="testCaseTitle", required=true)
        @CanIgnoreReturnValue
        public final Builder testCaseTitle(String testCaseTitle) {
            this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="environment", required=true)
        @CanIgnoreReturnValue
        public final Builder environment(String environment) {
            this.environment = Objects.requireNonNull(environment, "environment");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dataset(DataSet dataset) {
            this.dataset = Objects.requireNonNull(dataset, "dataset");
            return this;
        }

        @JsonProperty(value="dataset", required=true)
        @CanIgnoreReturnValue
        public final Builder dataset(Optional<? extends DataSet> dataset) {
            this.dataset = dataset.orElse(null);
            return this;
        }

        @JsonProperty(value="user", required=true)
        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder campaignReport(CampaignExecution campaignReport) {
            this.campaignReport = Objects.requireNonNull(campaignReport, "campaignReport");
            return this;
        }

        @JsonProperty(value="campaignReport", required=true)
        @CanIgnoreReturnValue
        public final Builder campaignReport(Optional<? extends CampaignExecution> campaignReport) {
            this.campaignReport = campaignReport.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(Set<String> tags) {
            this.tags = Objects.requireNonNull(tags, "tags");
            return this;
        }

        @JsonProperty(value="tags", required=true)
        @CanIgnoreReturnValue
        public final Builder tags(Optional<? extends Set<String>> tags) {
            this.tags = tags.orElse(null);
            return this;
        }

        @JsonProperty(value="executionId", required=true)
        @CanIgnoreReturnValue
        public final Builder executionId(Long executionId) {
            this.executionId = Objects.requireNonNull(executionId, "executionId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="scenarioId", required=true)
        @CanIgnoreReturnValue
        public final Builder scenarioId(String scenarioId) {
            this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableExecutionSummaryDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.dataset, this.user, this.campaignReport, this.tags, this.executionId, this.scenarioId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("time");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("duration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("testCaseTitle");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("environment");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("executionId");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("scenarioId");
            }
            return "Cannot build ExecutionSummaryDto, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ExecutionSummaryDto", generator="Immutables")
    static final class Json
    implements ExecutionSummaryDto {
        @JsonIgnore
        @Nullable
        LocalDateTime time;
        @JsonIgnore
        long duration;
        @JsonIgnore
        boolean durationIsSet;
        @JsonIgnore
        @Nullable
        ServerReportStatus status;
        @JsonIgnore
        @Nullable
        Optional<String> info = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> error = Optional.empty();
        @JsonIgnore
        @Nullable
        String testCaseTitle;
        @JsonIgnore
        @Nullable
        String environment;
        @JsonIgnore
        @Nullable
        Optional<DataSet> dataset = Optional.empty();
        @JsonIgnore
        @Nullable
        String user;
        @JsonIgnore
        @Nullable
        Optional<CampaignExecution> campaignReport = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<Set<String>> tags = Optional.empty();
        @JsonIgnore
        @Nullable
        Long executionId;
        @JsonIgnore
        @Nullable
        String scenarioId;

        Json() {
        }

        @JsonProperty(value="time", required=true)
        public void setTime(LocalDateTime time) {
            this.time = time;
        }

        @JsonProperty(value="duration", required=true)
        public void setDuration(long duration) {
            this.duration = duration;
            this.durationIsSet = true;
        }

        @JsonProperty(value="status", required=true)
        public void setStatus(ServerReportStatus status) {
            this.status = status;
        }

        @JsonProperty(value="info", required=true)
        public void setInfo(Optional<String> info) {
            this.info = info;
        }

        @JsonProperty(value="error", required=true)
        public void setError(Optional<String> error) {
            this.error = error;
        }

        @JsonProperty(value="testCaseTitle", required=true)
        public void setTestCaseTitle(String testCaseTitle) {
            this.testCaseTitle = testCaseTitle;
        }

        @JsonProperty(value="environment", required=true)
        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        @JsonProperty(value="dataset", required=true)
        public void setDataset(Optional<DataSet> dataset) {
            this.dataset = dataset;
        }

        @JsonProperty(value="user", required=true)
        public void setUser(String user) {
            this.user = user;
        }

        @JsonProperty(value="campaignReport", required=true)
        public void setCampaignReport(Optional<CampaignExecution> campaignReport) {
            this.campaignReport = campaignReport;
        }

        @JsonProperty(value="tags", required=true)
        public void setTags(Optional<Set<String>> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="executionId", required=true)
        public void setExecutionId(Long executionId) {
            this.executionId = executionId;
        }

        @JsonProperty(value="scenarioId", required=true)
        public void setScenarioId(String scenarioId) {
            this.scenarioId = scenarioId;
        }

        public LocalDateTime time() {
            throw new UnsupportedOperationException();
        }

        public long duration() {
            throw new UnsupportedOperationException();
        }

        public ServerReportStatus status() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> info() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> error() {
            throw new UnsupportedOperationException();
        }

        public String testCaseTitle() {
            throw new UnsupportedOperationException();
        }

        public String environment() {
            throw new UnsupportedOperationException();
        }

        public Optional<DataSet> dataset() {
            throw new UnsupportedOperationException();
        }

        public String user() {
            throw new UnsupportedOperationException();
        }

        public Optional<CampaignExecution> campaignReport() {
            throw new UnsupportedOperationException();
        }

        public Optional<Set<String>> tags() {
            throw new UnsupportedOperationException();
        }

        public Long executionId() {
            throw new UnsupportedOperationException();
        }

        public String scenarioId() {
            throw new UnsupportedOperationException();
        }
    }
}

