/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api;

import fr.enedis.chutney.execution.api.ExecutionSummaryDto;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.RunningScenarioExecutionDeleteException;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import fr.enedis.chutney.server.core.domain.execution.history.ImmutableExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.PurgeReport;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
class ScenarioExecutionHistoryController {
    private final ExecutionHistoryRepository executionHistoryRepository;

    ScenarioExecutionHistoryController(ExecutionHistoryRepository executionHistoryRepository) {
        this.executionHistoryRepository = executionHistoryRepository;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/{scenarioId}/execution/v1"}, produces={"application/json"})
    public List<ExecutionSummaryDto> listExecutions(@PathVariable(value="scenarioId") String scenarioId) {
        return ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutions(scenarioId));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/execution/{executionId}/summary/v1"}, produces={"application/json"})
    public ExecutionSummaryDto getExecutionSummary(@PathVariable(value="executionId") Long executionId) {
        return ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutionSummary(executionId));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/{scenarioId}/execution/{executionId}/v1"}, produces={"application/json"})
    public ExecutionHistory.Execution getExecutionReport(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(scenarioId, executionId);
        if (execution.dataset().isPresent() && ((DataSet)execution.dataset().get()).id == null && (((DataSet)execution.dataset().get()).datatable == null || ((DataSet)execution.dataset().get()).datatable.isEmpty()) && (((DataSet)execution.dataset().get()).constants == null || ((DataSet)execution.dataset().get()).constants.isEmpty())) {
            return ImmutableExecutionHistory.Execution.copyOf((ExecutionHistory.Execution)execution).withDataset(Optional.empty());
        }
        return execution;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @DeleteMapping(path={"/api/ui/scenario/execution/{executionId}"})
    public void deleteExecution(@PathVariable(value="executionId") Long executionId) {
        PurgeReport report = this.executionHistoryRepository.deleteExecutions(Set.of(executionId));
        if (report.scenariosExecutionsIds().isEmpty()) {
            throw new RunningScenarioExecutionDeleteException(executionId);
        }
    }
}

