/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import fr.enedis.chutney.dataset.api.DataSetMapper;
import fr.enedis.chutney.dataset.api.ExecutionDatasetDto;
import fr.enedis.chutney.dataset.domain.DataSetRepository;
import fr.enedis.chutney.environment.api.environment.EmbeddedEnvironmentApi;
import fr.enedis.chutney.execution.api.IdeaRequest;
import fr.enedis.chutney.execution.api.ScenarioExecutionReportMapper;
import fr.enedis.chutney.execution.domain.GwtScenarioMarshaller;
import fr.enedis.chutney.scenario.api.raw.mapper.GwtScenarioMapper;
import fr.enedis.chutney.scenario.domain.gwt.GwtScenario;
import fr.enedis.chutney.scenario.domain.gwt.GwtTestCase;
import fr.enedis.chutney.security.infra.SpringUserService;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.ExecutionRequest;
import fr.enedis.chutney.server.core.domain.execution.ScenarioExecutionEngine;
import fr.enedis.chutney.server.core.domain.execution.ScenarioExecutionEngineAsync;
import fr.enedis.chutney.server.core.domain.execution.report.ScenarioExecutionReport;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotFoundException;
import fr.enedis.chutney.server.core.domain.scenario.TestCase;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadataImpl;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseRepository;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Observable;
import java.io.IOException;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
public class ScenarioExecutionUiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioExecutionUiController.class);
    private static final GwtScenarioMarshaller marshaller = new GwtScenarioMapper();
    private final ScenarioExecutionEngine executionEngine;
    private final ScenarioExecutionEngineAsync executionEngineAsync;
    private final TestCaseRepository testCaseRepository;
    private final ObjectMapper objectMapper;
    private final ObjectMapper reportObjectMapper;
    private final SpringUserService userService;
    private final DataSetRepository datasetRepository;
    private final ScenarioExecutionReportMapper scenarioExecutionReportMapper;
    private final EmbeddedEnvironmentApi embeddedEnvironmentApi;

    ScenarioExecutionUiController(ScenarioExecutionEngine executionEngine, ScenarioExecutionEngineAsync executionEngineAsync, TestCaseRepository testCaseRepository, ObjectMapper objectMapper, SpringUserService userService, DataSetRepository datasetRepository, ScenarioExecutionReportMapper scenarioExecutionReportMapper, EmbeddedEnvironmentApi embeddedEnvironmentApi) {
        this.executionEngine = executionEngine;
        this.executionEngineAsync = executionEngineAsync;
        this.testCaseRepository = testCaseRepository;
        this.objectMapper = objectMapper;
        this.embeddedEnvironmentApi = embeddedEnvironmentApi;
        this.reportObjectMapper = this.dtoReportObjectMapper();
        this.userService = userService;
        this.datasetRepository = datasetRepository;
        this.scenarioExecutionReportMapper = scenarioExecutionReportMapper;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/idea/scenario/execution/{env}"})
    public String executeScenarioWitRawContent(@RequestBody IdeaRequest ideaRequest, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("execute Scenario v2 for content='{}'", (Object)ideaRequest.content());
        String userId = this.userService.currentUser().getId();
        GwtScenario gwtScenario = marshaller.deserialize("test title for idea", "test description for idea", ideaRequest.content());
        GwtTestCase testCase = GwtTestCase.builder().withMetadata(TestCaseMetadataImpl.builder().withDescription("test description for idea").withTitle("test title for idea").build()).withScenario(gwtScenario).build();
        ScenarioExecutionReport report = this.executionEngine.simpleSyncExecution(new ExecutionRequest((TestCase)testCase, env, userId));
        return this.objectMapper.writeValueAsString((Object)report);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/{env}", "/api/ui/scenario/executionasync/v1/{scenarioId}/{env}"}, consumes={"application/json"}, produces={"application/json"})
    public String executeScenarioAsyncWithExecutionParameters(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="env") String env, @RequestBody(required=false) ExecutionDatasetDto dataset) {
        LOGGER.debug("execute async scenario '{}'", (Object)scenarioId);
        TestCase testCase = (TestCase)this.testCaseRepository.findExecutableById(scenarioId).orElseThrow(() -> new ScenarioNotFoundException(scenarioId));
        String userId = this.userService.currentUser().getId();
        DataSet execDataset = this.getDataSet(dataset, testCase);
        return this.executionEngineAsync.execute(new ExecutionRequest(testCase, env, userId, execDataset)).toString();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}"}, consumes={"application/json"}, produces={"application/json"})
    public String executeScenarioAsyncOnDefaultEnv(@PathVariable(value="scenarioId") String scenarioId) {
        return this.executeScenarioAsyncWithExecutionParameters(scenarioId, this.embeddedEnvironmentApi.defaultEnvironmentName(), null);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/execution/v1/{scenarioId}/{env}"})
    public String executeScenario(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="env") String env) throws IOException {
        LOGGER.debug("executeScenario for scenarioId='{}'", (Object)scenarioId);
        TestCase testCase = (TestCase)this.testCaseRepository.findExecutableById(scenarioId).orElseThrow(() -> new ScenarioNotFoundException(scenarioId));
        String userId = this.userService.currentUserId();
        DataSet dataset = this.getDataSetFromTestCase(testCase);
        ScenarioExecutionReport report = this.executionEngine.simpleSyncExecution(new ExecutionRequest(testCase, env, userId, dataset));
        return this.reportObjectMapper.writeValueAsString((Object)this.scenarioExecutionReportMapper.toDto(report));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}"})
    public Flux<ServerSentEvent<String>> followScenarioExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("followScenarioExecution for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        return this.createScenarioExecutionSSEFlux((Observable<ScenarioExecutionReport>)this.executionEngineAsync.followExecution(scenarioId, executionId));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/stop"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void stopExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Stop for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.stop(scenarioId, executionId);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/pause"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void pauseExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Pause for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.pause(scenarioId, executionId);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE')")
    @PostMapping(path={"/api/ui/scenario/executionasync/v1/{scenarioId}/execution/{executionId}/resume"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resumeExecution(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        LOGGER.debug("Resume for scenarioId='{}' and executionID='{}'", (Object)scenarioId, (Object)executionId);
        this.executionEngineAsync.resume(scenarioId, executionId);
    }

    private Flux<ServerSentEvent<String>> createScenarioExecutionSSEFlux(Observable<ScenarioExecutionReport> scenarioExecutionReports) {
        return Flux.from((Publisher)scenarioExecutionReports.map(reportEvent -> ServerSentEvent.builder().id(String.valueOf(reportEvent.executionId)).event(reportEvent.report.isTerminated() ? "last" : "partial").data((Object)this.reportObjectMapper.writeValueAsString(reportEvent)).build()).toFlowable(BackpressureStrategy.BUFFER));
    }

    private DataSet getDataSetFromTestCase(TestCase testCase) {
        String defaultDatasetId = testCase.metadata().defaultDataset();
        if (!defaultDatasetId.isEmpty()) {
            return this.datasetRepository.findById(defaultDatasetId);
        }
        return DataSet.NO_DATASET;
    }

    private DataSet getDataSet(ExecutionDatasetDto dataset, TestCase testCase) {
        return Optional.ofNullable(DataSetMapper.fromExecutionDatasetDto(dataset, this.datasetRepository::findById)).orElseGet(() -> this.getDataSetFromTestCase(testCase));
    }

    public ObjectMapper dtoReportObjectMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).findAndRegisterModules();
    }
}

