/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.domain.purge;

import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.function.Predicate;

class PurgeExecutionsFilters {
    static Predicate<ExecutionHistory.ExecutionSummary> isScenarioExecutionLinkedWithCampaignExecution = es -> es.campaignReport().isEmpty();

    PurgeExecutionsFilters() {
    }

    static <Execution> Predicate<Execution> isExecutionDateBeforeNowMinusOffset(Function<Execution, LocalDateTime> executionDateFunction, int nowOffsetMillis) {
        if (nowOffsetMillis <= 0) {
            return e -> true;
        }
        return exec -> {
            LocalDateTime now = LocalDateTime.now().minus(nowOffsetMillis, ChronoUnit.MILLIS);
            return ((LocalDateTime)executionDateFunction.apply(exec)).isBefore(now);
        };
    }
}

