/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.infra.execution;

import fr.enedis.chutney.agent.domain.explore.CurrentNetworkDescription;
import fr.enedis.chutney.agent.domain.network.Agent;
import fr.enedis.chutney.agent.domain.network.NetworkDescription;
import fr.enedis.chutney.engine.api.execution.EnvironmentDto;
import fr.enedis.chutney.engine.api.execution.ExecutionRequestDto;
import fr.enedis.chutney.engine.api.execution.TargetExecutionDto;
import fr.enedis.chutney.engine.domain.delegation.NamedHostAndPort;
import fr.enedis.chutney.environment.api.environment.EmbeddedEnvironmentApi;
import fr.enedis.chutney.environment.api.environment.EnvironmentApi;
import fr.enedis.chutney.environment.api.target.EmbeddedTargetApi;
import fr.enedis.chutney.environment.api.target.TargetApi;
import fr.enedis.chutney.environment.api.target.dto.NoTargetDto;
import fr.enedis.chutney.environment.api.target.dto.TargetDto;
import fr.enedis.chutney.environment.api.variable.dto.EnvironmentVariableDto;
import fr.enedis.chutney.execution.infra.execution.DatasetMapper;
import fr.enedis.chutney.execution.infra.execution.ExecutionRequestMapper;
import fr.enedis.chutney.scenario.domain.gwt.GwtStep;
import fr.enedis.chutney.scenario.domain.gwt.GwtTestCase;
import fr.enedis.chutney.scenario.domain.gwt.Strategy;
import fr.enedis.chutney.server.core.domain.execution.ExecutionRequest;
import fr.enedis.chutney.server.core.domain.execution.ScenarioConversionException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultExecutionRequestMapper
implements ExecutionRequestMapper {
    private final TargetApi targetApi;
    private final EnvironmentApi environmentApi;
    private final CurrentNetworkDescription currentNetworkDescription;

    public DefaultExecutionRequestMapper(EmbeddedTargetApi targetApi, EmbeddedEnvironmentApi environmentApi, CurrentNetworkDescription currentNetworkDescription) {
        this.targetApi = targetApi;
        this.environmentApi = environmentApi;
        this.currentNetworkDescription = currentNetworkDescription;
    }

    @Override
    public ExecutionRequestDto toDto(ExecutionRequest executionRequest) {
        ExecutionRequestDto.StepDefinitionRequestDto stepDefinitionRequestDto = this.convertToStepDef(executionRequest);
        return new ExecutionRequestDto(stepDefinitionRequestDto, this.getEnvironment(executionRequest.environment), DatasetMapper.toDto(executionRequest.dataset));
    }

    private EnvironmentDto getEnvironment(String env) {
        Map<String, String> variables = this.environmentApi.getEnvironment((String)env).variables.stream().collect(Collectors.toMap(EnvironmentVariableDto::key, EnvironmentVariableDto::value));
        return new EnvironmentDto(env, variables);
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertToStepDef(ExecutionRequest executionRequest) {
        if (executionRequest.testCase instanceof GwtTestCase) {
            return this.convertGwt(executionRequest);
        }
        throw new ScenarioConversionException(executionRequest.testCase.metadata().id(), "Cannot create an executable StepDefinition from a " + executionRequest.testCase.getClass().getCanonicalName());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertGwt(ExecutionRequest executionRequest) {
        GwtTestCase gwtTestCase = (GwtTestCase)executionRequest.testCase;
        return new ExecutionRequestDto.StepDefinitionRequestDto(gwtTestCase.metadata.title, null, null, null, Collections.emptyMap(), this.convert(gwtTestCase.scenario.steps(), executionRequest.environment), Collections.emptyMap(), Collections.emptyMap());
    }

    private List<ExecutionRequestDto.StepDefinitionRequestDto> convert(List<GwtStep> steps, String env) {
        return steps.stream().map(s -> this.convert((GwtStep)s, env)).collect(Collectors.toList());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convert(GwtStep step, String env) {
        return new ExecutionRequestDto.StepDefinitionRequestDto(step.description, step.implementation.map(i -> this.toExecutionTargetDto(this.getTargetForExecution(env, i.target), env)).orElse(this.toExecutionTargetDto(NoTargetDto.NO_TARGET_DTO, env)), (ExecutionRequestDto.StepStrategyDefinitionRequestDto)step.strategy.map(this::mapStrategy).orElse(null), step.implementation.map(i -> i.type).orElse(""), step.implementation.map(i -> i.inputs).orElse(Collections.emptyMap()), this.convert(step.subSteps, env), step.implementation.map(i -> i.outputs).orElse(Collections.emptyMap()), step.implementation.map(i -> i.validations).orElse(Collections.emptyMap()));
    }

    private ExecutionRequestDto.StepStrategyDefinitionRequestDto mapStrategy(Strategy strategy) {
        return new ExecutionRequestDto.StepStrategyDefinitionRequestDto(strategy.type, strategy.parameters);
    }

    private TargetExecutionDto toExecutionTargetDto(TargetDto targetDto, String env) {
        if (targetDto == null || NoTargetDto.NO_TARGET_DTO.equals(targetDto)) {
            targetDto = NoTargetDto.NO_TARGET_DTO;
        }
        return new TargetExecutionDto(targetDto.name, targetDto.url, targetDto.propertiesToMap(), this.getAgents(targetDto, env));
    }

    private TargetDto getTargetForExecution(String environmentName, String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            return NoTargetDto.NO_TARGET_DTO;
        }
        return this.targetApi.getTarget(environmentName, targetName);
    }

    private List<NamedHostAndPort> getAgents(TargetDto targetDto, String env) {
        List<Object> nhaps = Collections.emptyList();
        Optional<NetworkDescription> networkDescription = this.currentNetworkDescription.findCurrent();
        if (networkDescription.isPresent() && networkDescription.get().localAgent().isPresent()) {
            Agent localAgent = networkDescription.get().localAgent().get();
            List<Agent> agents = localAgent.findFellowAgentForReaching(targetDto.name, env);
            nhaps = agents.stream().map(a -> a.agentInfo).collect(Collectors.toList());
        }
        return nhaps;
    }
}

